/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.utils;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class PackageResolver {
    public static String findActualRoot() {
        try {
            return PackageResolver.findActualRoot("./src/main/java");
        }
        catch (Exception e) {
            throw new RuntimeException("Can't extract actual root: " + String.valueOf(e));
        }
    }

    public static String findActualRoot(String path) throws IOException {
        List<Path> subDirectories = PackageResolver.findSubdirectories(path);
        if (subDirectories.size() == 1) {
            return PackageResolver.findActualRoot(subDirectories.get(0).toString());
        }
        return path;
    }

    public static List<Path> findSubdirectories(String path) throws IOException {
        return Files.walk(Paths.get(path, new String[0]), 1, new FileVisitOption[0]).filter(entry -> Files.isDirectory(entry, new LinkOption[0]) && !entry.equals(Path.of(path, new String[0]))).collect(Collectors.toList());
    }
}

