/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.utils.technologyFactory;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ComponentTechnologyFactory {
    private Database database;
    private Rest rest;
    private Kafka kafka;

    public ComponentTechnologyFactory(String databaseType, Boolean flyway, Boolean rest) {
        this.database = new Database(databaseType, flyway);
        this.rest = new Rest(rest);
    }

    public ComponentTechnologyFactory(String databaseType, Boolean flyway, Boolean rest, String readKafkaTopic, String writeKafkaTopic) {
        this.database = new Database(databaseType, flyway);
        this.rest = new Rest(rest);
        this.kafka = new Kafka(readKafkaTopic, writeKafkaTopic);
    }

    public String create() {
        if (this.kafka == null) {
            return this.createTechnology(this.database, this.rest, null);
        }
        return this.createTechnology(this.database, this.rest, this.kafka);
    }

    private String createTechnology(Database database, Rest rest, Kafka kafka) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Technology technology = new Technology();
        technology.setLanguage("java");
        technology.setDatabase(database);
        technology.setRest(rest);
        technology.setKafka(kafka);
        JsonObject jsonResult = new JsonObject();
        jsonResult.add("technology", gson.toJsonTree((Object)technology));
        return gson.toJson((JsonElement)jsonResult);
    }

    public Database getDatabase() {
        return this.database;
    }

    public Rest getRest() {
        return this.rest;
    }

    public Kafka getKafka() {
        return this.kafka;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setRest(Rest rest) {
        this.rest = rest;
    }

    public void setKafka(Kafka kafka) {
        this.kafka = kafka;
    }

    static class Database {
        private String type;
        private Boolean flyway;

        public String getType() {
            return this.type;
        }

        public Boolean getFlyway() {
            return this.flyway;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setFlyway(Boolean flyway) {
            this.flyway = flyway;
        }

        public Database(String type, Boolean flyway) {
            this.type = type;
            this.flyway = flyway;
        }
    }

    static class Rest {
        private Boolean isExposed;

        public Boolean getIsExposed() {
            return this.isExposed;
        }

        public void setIsExposed(Boolean isExposed) {
            this.isExposed = isExposed;
        }

        public Rest(Boolean isExposed) {
            this.isExposed = isExposed;
        }
    }

    static class Kafka {
        private String readTopic;
        private String writeTopic;
        private Topic[] read;
        private Topic[] write;

        Kafka(String readTopic, String writeTopic) {
            this.read = new Topic[]{new Topic(readTopic)};
            this.write = new Topic[]{new Topic(writeTopic)};
        }

        public String getReadTopic() {
            return this.readTopic;
        }

        public String getWriteTopic() {
            return this.writeTopic;
        }

        public Topic[] getRead() {
            return this.read;
        }

        public Topic[] getWrite() {
            return this.write;
        }

        public void setReadTopic(String readTopic) {
            this.readTopic = readTopic;
        }

        public void setWriteTopic(String writeTopic) {
            this.writeTopic = writeTopic;
        }

        public void setRead(Topic[] read) {
            this.read = read;
        }

        public void setWrite(Topic[] write) {
            this.write = write;
        }
    }

    static class Technology {
        private String language;
        private Database database;
        private Rest rest;
        private Kafka kafka;

        Technology() {
        }

        public String getLanguage() {
            return this.language;
        }

        public Database getDatabase() {
            return this.database;
        }

        public Rest getRest() {
            return this.rest;
        }

        public Kafka getKafka() {
            return this.kafka;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public void setDatabase(Database database) {
            this.database = database;
        }

        public void setRest(Rest rest) {
            this.rest = rest;
        }

        public void setKafka(Kafka kafka) {
            this.kafka = kafka;
        }
    }

    static class Topic {
        private String topic;

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public Topic(String topic) {
            this.topic = topic;
        }
    }
}

