/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogBuffer;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogFileManager;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogObject;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.LogRecordSizeException;
import org.objectweb.howl.log.ReplayListener;

class LogBufferManager
extends LogObject {
    private final Object bufferManagerLock = new Object();
    private final Object forceManagerLock = new Object();
    private LogFileManager lfm = null;
    private LogBuffer fillBuffer = null;
    private LogBuffer[] freeBuffer = null;
    short nextIndex = 0;
    private long waitForBuffer = 0L;
    private long noRoomInBuffer = 0L;
    private int growPoolCounter = 0;
    private int bufferManagerError = 0;
    int nextFillBSN = 1;
    int nextWriteBSN = 1;
    int lastForceBSN = 0;
    private long forceCount = 0L;
    private long writeCount = 0L;
    private int minBuffersForced = Integer.MAX_VALUE;
    private int maxBuffersForced = Integer.MIN_VALUE;
    private long totalForceTime = 0L;
    private long totalWriteTime = 0L;
    private long maxWriteTime = 0L;
    private long totalWaitForWriteLockTime = 0L;
    private long totalTimeBetweenForce = 0L;
    private long minTimeBetweenForce = Long.MAX_VALUE;
    private long maxTimeBetweenForce = Long.MIN_VALUE;
    private long lastForceTOD = 0L;
    private int threadsWaitingForce = 0;
    private int maxThreadsWaitingForce = 0;
    private long totalThreadsWaitingForce = 0L;
    private int threadsWaitingForceThreshold = 0;
    long forceOnTimeout = 0L;
    long forceNoWaitingThreads = 0L;
    long forceHalfOfBuffers = 0L;
    long forceMaxWaitingThreads = 0L;
    final Thread flushManager;
    private static final String flushManagerName = "FlushManager";
    private LogBuffer[] forceQueue = null;
    private int fqPut = 0;
    private int fqGet = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$objectweb$howl$log$LogBufferManager;
    static /* synthetic */ Class class$org$objectweb$howl$log$Configuration;

    LogBufferManager(Configuration config) {
        super(config);
        this.threadsWaitingForceThreshold = config.getThreadsWaitingForceThreshold();
        this.flushManager = new FlushManager(flushManagerName);
        this.flushManager.setDaemon(true);
    }

    final long elapsedTime(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void force(boolean timeout) throws IOException, InterruptedException {
        LogBuffer logBuffer = null;
        long startWait = System.currentTimeMillis();
        Object object = this.forceManagerLock;
        synchronized (object) {
            this.totalWaitForWriteLockTime += this.elapsedTime(startWait);
            logBuffer = this.forceQueue[this.fqGet];
            this.fqGet = (this.fqGet + 1) % this.forceQueue.length;
            try {
                if (!$assertionsDisabled && logBuffer.bsn != this.nextWriteBSN) {
                    throw new AssertionError((Object)("BSN error expecting " + this.nextWriteBSN + " found " + logBuffer.bsn));
                }
                long startWrite = System.currentTimeMillis();
                logBuffer.write();
                long writeTime = this.elapsedTime(startWrite);
                this.totalWriteTime += writeTime;
                if (writeTime > this.maxWriteTime) {
                    this.maxWriteTime = writeTime;
                }
                ++this.writeCount;
                this.nextWriteBSN = logBuffer.bsn + 1;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.threadsWaitingForce += logBuffer.getWaitingThreads();
            if (this.threadsWaitingForce > this.maxThreadsWaitingForce) {
                this.maxThreadsWaitingForce = this.threadsWaitingForce;
            }
            int forcebsn = this.nextWriteBSN - 1;
            boolean doforce = true;
            if (logBuffer.bsn <= this.lastForceBSN) {
                doforce = false;
            } else if (this.fqGet == this.fqPut) {
                ++this.forceNoWaitingThreads;
            } else if (timeout) {
                ++this.forceOnTimeout;
            } else if (forcebsn - this.lastForceBSN > this.freeBuffer.length / 2) {
                ++this.forceHalfOfBuffers;
            } else if (this.threadsWaitingForce > this.threadsWaitingForceThreshold) {
                ++this.forceMaxWaitingThreads;
            } else {
                doforce = false;
            }
            if (doforce) {
                ++this.forceCount;
                long startForce = System.currentTimeMillis();
                logBuffer.lf.force(false);
                this.totalForceTime += this.elapsedTime(startForce);
                if (this.lastForceTOD > 0L) {
                    long timeBetweenForce = startForce - this.lastForceTOD;
                    this.totalTimeBetweenForce += timeBetweenForce;
                    this.minTimeBetweenForce = Math.min(this.minTimeBetweenForce, timeBetweenForce);
                    if (!timeout) {
                        this.maxTimeBetweenForce = Math.max(this.maxTimeBetweenForce, timeBetweenForce);
                    }
                }
                this.lastForceTOD = System.currentTimeMillis();
                if (this.lastForceBSN > 0) {
                    int buffersForced = forcebsn - this.lastForceBSN;
                    this.maxBuffersForced = Math.max(this.maxBuffersForced, buffersForced);
                    this.minBuffersForced = Math.min(this.minBuffersForced, buffersForced);
                }
                this.totalThreadsWaitingForce += (long)this.threadsWaitingForce;
                this.threadsWaitingForce = 0;
                this.lastForceBSN = forcebsn;
                this.forceManagerLock.notifyAll();
            }
            while (this.lastForceBSN < logBuffer.bsn) {
                this.forceManagerLock.wait();
            }
        }
        if (logBuffer.iostatus == 1) {
            logBuffer.iostatus = 2;
        }
        LogBuffer logBuffer2 = logBuffer;
        synchronized (logBuffer2) {
            logBuffer.notifyAll();
        }
        this.releaseBuffer(logBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(LogBuffer logBuffer) throws IOException, InterruptedException {
        try {
            logBuffer.sync();
            Object var3_2 = null;
            this.releaseBuffer(logBuffer);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseBuffer(logBuffer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBuffer(LogBuffer buffer) {
        if (buffer.release() == 0) {
            Object object = this.bufferManagerLock;
            synchronized (object) {
                this.freeBuffer[buffer.index] = buffer;
                this.bufferManagerLock.notifyAll();
            }
        }
    }

    private LogBuffer getFillBuffer() throws LogFileOverflowException {
        if (this.fillBuffer == null) {
            int fbl = this.freeBuffer.length;
            int i = 0;
            while (this.fillBuffer == null && i < fbl) {
                this.nextIndex = (short)(this.nextIndex % fbl);
                if (this.freeBuffer[this.nextIndex] != null) {
                    LogBuffer b = this.freeBuffer[this.nextIndex];
                    this.freeBuffer[this.nextIndex] = null;
                    this.fillBuffer = b.init(this.nextFillBSN, this.lfm);
                    ++this.nextFillBSN;
                }
                this.nextIndex = (short)(this.nextIndex + 1);
                ++i;
            }
        }
        return this.fillBuffer;
    }

    LogBuffer getLogBuffer(int index) throws ClassNotFoundException {
        LogBuffer lb = null;
        Class<?> lbcls = this.getClass().getClassLoader().loadClass(this.config.getBufferClassName());
        try {
            Constructor<?> lbCtor = lbcls.getDeclaredConstructor(class$org$objectweb$howl$log$Configuration == null ? (class$org$objectweb$howl$log$Configuration = LogBufferManager.class$("org.objectweb.howl.log.Configuration")) : class$org$objectweb$howl$log$Configuration);
            lb = (LogBuffer)lbCtor.newInstance(this.config);
            lb.index = index;
        }
        catch (InstantiationException e) {
            throw new ClassNotFoundException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException(e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new ClassNotFoundException(e.toString());
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new ClassNotFoundException(e.toString());
        }
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long put(short type, byte[][] data, boolean sync) throws LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        long token = 0L;
        LogBuffer currentBuffer = null;
        do {
            Object object = this.bufferManagerLock;
            synchronized (object) {
                while ((currentBuffer = this.getFillBuffer()) == null) {
                    ++this.waitForBuffer;
                    this.bufferManagerLock.wait();
                }
                token = currentBuffer.put(type, data, sync);
                if (token == 0L) {
                    this.fillBuffer = null;
                    this.forceQueue[this.fqPut] = currentBuffer;
                    this.fqPut = (this.fqPut + 1) % this.forceQueue.length;
                }
            }
            if (token == 0L) {
                ++this.noRoomInBuffer;
                this.force(false);
                if (currentBuffer.iostatus != 3) continue;
                throw currentBuffer.ioexception;
            }
            if (!sync) continue;
            this.sync(currentBuffer);
        } while (token == 0L);
        return token;
    }

    void replay(ReplayListener listener, long mark, boolean replayCtrlRecords) throws LogConfigurationException, InvalidLogKeyException {
        long markBSN;
        if (mark < 0L) {
            throw new InvalidLogKeyException("log key [" + mark + "] must be >= zero");
        }
        LogBuffer buffer = null;
        try {
            buffer = this.getLogBuffer(-1);
        }
        catch (ClassNotFoundException e) {
            throw new LogConfigurationException(e.toString());
        }
        LogRecord record = listener.getLogRecord();
        try {
            this.lfm.read(buffer, this.bsnFromMark(mark));
        }
        catch (IOException e) {
            String msg = "Error reading " + buffer.lf.file + " @ position [" + buffer.lf.position + "]";
            listener.onError(new LogException(msg + e.toString()));
            return;
        }
        catch (InvalidLogBufferException e) {
            listener.onError(new LogException(e.toString()));
            return;
        }
        if (buffer.bsn == -1) {
            record.type = (short)19983;
            listener.onRecord(record);
            return;
        }
        long l = markBSN = mark == 0L ? (long)buffer.bsn : (long)this.bsnFromMark(mark);
        if (markBSN != (long)buffer.bsn) {
            InvalidLogBufferException lbe = new InvalidLogBufferException("block read [" + buffer.bsn + "] not block requested: " + markBSN);
            listener.onError(lbe);
            return;
        }
        try {
            record.get(buffer);
            if (mark > 0L) {
                while (record.key < mark) {
                    record.get(buffer);
                }
                if (record.key != mark) {
                    String msg = "The initial mark [" + Long.toHexString(mark) + "] requested for replay was not found in the log.";
                    listener.onError(new InvalidLogKeyException(msg));
                    return;
                }
            }
        }
        catch (InvalidLogBufferException e) {
            listener.onError(new LogException(e.toString()));
            return;
        }
        long nrecs = 0L;
        int nextBSN = 0;
        while (true) {
            if (record.isEOB()) {
                nextBSN = buffer.bsn + 1;
                try {
                    this.lfm.read(buffer, nextBSN);
                }
                catch (IOException e) {
                    listener.onError(new LogException(e.toString()));
                    return;
                }
                catch (InvalidLogBufferException e) {
                    listener.onError(new LogException(e.toString()));
                    return;
                }
                if (buffer.bsn == -1) {
                    record.type = (short)19983;
                    listener.onRecord(record);
                    return;
                }
            } else if (!record.isCTRL() || replayCtrlRecords) {
                listener.onRecord(record);
            }
            ++nrecs;
            try {
                record.get(buffer);
            }
            catch (InvalidLogBufferException e) {
                listener.onError(e);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws ClassNotFoundException {
        int bufferPoolSize = this.config.getMinBuffers();
        this.freeBuffer = new LogBuffer[bufferPoolSize];
        int i = 0;
        while (i < bufferPoolSize) {
            this.freeBuffer[i] = this.getLogBuffer(i);
            i = (short)(i + 1);
        }
        Object object = this.forceManagerLock;
        synchronized (object) {
            this.forceQueue = new LogBuffer[bufferPoolSize + 1];
        }
        if (this.flushManager != null) {
            this.flushManager.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(LogFileManager lfm, int bsn) {
        if (!$assertionsDisabled && lfm == null) {
            throw new AssertionError((Object)"constructor requires non-null LogFileManager parameter");
        }
        this.lfm = lfm;
        this.nextFillBSN = bsn + 1;
        Object object = this.forceManagerLock;
        synchronized (object) {
            this.nextWriteBSN = this.nextFillBSN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAll() throws IOException {
        try {
            int i = 0;
            while (i < this.freeBuffer.length) {
                Object object = this.bufferManagerLock;
                synchronized (object) {
                    while (this.freeBuffer[i] == null) {
                        this.bufferManagerLock.wait();
                    }
                }
                ++i;
            }
        }
        catch (InterruptedException e) {}
    }

    private String doubleToString(double val, int decimalPlaces) {
        String s = "" + val;
        int dp = s.indexOf(46) + 1;
        if (s.length() > dp + decimalPlaces) {
            s = s.substring(0, dp + decimalPlaces);
        }
        return s;
    }

    String getStats() {
        String avgThreadsWaitingForce = this.doubleToString((double)this.totalThreadsWaitingForce / (double)this.forceCount, 2);
        String avgForceTime = this.doubleToString((double)this.totalForceTime / (double)this.forceCount, 2);
        String avgTimeBetweenForce = this.doubleToString((double)this.totalTimeBetweenForce / (double)this.forceCount, 2);
        String avgBuffersPerForce = this.doubleToString((double)this.writeCount / (double)this.forceCount, 2);
        String avgWriteTime = this.doubleToString((double)this.totalWriteTime / (double)this.writeCount, 2);
        String avgWaitForWriteLockTime = this.doubleToString((double)this.totalWaitForWriteLockTime / (double)this.writeCount, 2);
        String name = this.getClass().getName();
        StringBuffer stats = new StringBuffer("\n<LogBufferManager  class='" + name + "'>" + "\n  <bufferSize value='" + this.config.getBufferSize() + "'>" + "Buffer Size (in bytes)" + "</bufferSize>" + "\n  <poolsize    value='" + this.freeBuffer.length + "'>" + "Number of buffers in the pool" + "</poolsize>" + "\n  <initialPoolSize value='" + this.config.getMinBuffers() + "'>" + "Initial number of buffers in the pool" + "</initialPoolSize>" + "\n  <growPoolCounter value='" + this.growPoolCounter + "'>" + "Number of times buffer pool was grown" + "</growPoolCounter>" + "\n  <bufferwait  value='" + this.getWaitForBuffer() + "'>" + "Wait for available buffer" + "</bufferwait>" + "\n  <forceCount  value='" + this.forceCount + "'>Number of channel.force() calls</forceCount>" + "\n  <totalForceTime   value='" + this.totalForceTime + "'>Total time (ms) spent in channel.force</totalForceTime>" + "\n  <avgForceTime value='" + avgForceTime + "'>Average channel.force() time (ms)</avgForceTime>" + "\n  <totalTimeBetweenForce value='" + this.totalTimeBetweenForce + "'>Total time (ms) between calls to channel.force()</totalTimeBetweenForce>" + "\n  <minTimeBetweenForce value='" + this.minTimeBetweenForce + "'>Minimum time (ms) between calls to channel.force()</minTimeBetweenForce>" + "\n  <maxTimeBetweenForce value='" + this.maxTimeBetweenForce + "'>Maximum time (ms) between calls to channel.force()</maxTimeBetweenForce>" + "\n  <avgTimeBetweenForce value='" + avgTimeBetweenForce + "'>Average time (ms) between calls to channel.force()</avgTimeBetweenForce>" + "\n  <writeCount  value='" + this.writeCount + "'>Number of channel.write() calls</writeCount>" + "\n  <avgBuffersPerForce value='" + avgBuffersPerForce + "'>Average number of buffers per force</avgBuffersPerForce>" + "\n  <minBuffersForced value='" + this.minBuffersForced + "'>Minimum number of buffers forced</minBuffersForced>" + "\n  <maxBuffersForced value='" + this.maxBuffersForced + "'>Maximum number of buffers forced</maxBuffersForced>" + "\n  <totalWriteTime   value='" + this.totalWriteTime + "'>Total time (ms) spent in channel.write</totalWriteTime>" + "\n  <avgWriteTime value='" + avgWriteTime + "'>Average channel.write() time (ms)</avgWriteTime>" + "\n  <maxWriteTime value='" + this.maxWriteTime + "'>Maximum channel.write() time (ms)</maxWriteTime>" + "\n  <totalWaitForWriteLockTime   value='" + this.totalWaitForWriteLockTime + "'>Total time (ms) spent waiting for forceManagerLock to issue a write</totalWaitForWriteLockTime>" + "\n  <avgWaitForWriteLockTime   value='" + avgWaitForWriteLockTime + "'>Total time (ms) spent waiting for forceManagerLock to issue a write</avgWaitForWriteLockTime>" + "\n  <bufferfull  value='" + this.noRoomInBuffer + "'>Buffer full</bufferfull>" + "\n  <nextfillbsn value='" + this.nextFillBSN + "'></nextfillbsn>" + "\n  <forceOnTimeout value='" + this.forceOnTimeout + "'></forceOnTimeout>" + "\n  <forceNoWaitingThreads value='" + this.forceNoWaitingThreads + "'>force because no other trheads waiting on force</forceNoWaitingThreads>" + "\n  <forceHalfOfBuffers value='" + this.forceHalfOfBuffers + "'>force due to 1/2 of buffers waiting</forceHalfOfBuffers>" + "\n  <forceMaxWaitingThreads value='" + this.forceMaxWaitingThreads + "'>force due to max waiting threads</forceMaxWaitingThreads>" + "\n  <maxThreadsWaitingForce value='" + this.maxThreadsWaitingForce + "'>maximum threads waiting</maxThreadsWaitingForce>" + "\n  <avgThreadsWaitingForce value='" + avgThreadsWaitingForce + "'>Avg threads waiting force</avgThreadsWaitingForce>" + "\n  <LogBufferPool>" + "\n");
        int i = 0;
        while (i < this.freeBuffer.length) {
            if (this.freeBuffer[i] != null) {
                stats.append(this.freeBuffer[i].getStats());
            }
            ++i;
        }
        stats.append("\n</LogBufferPool>\n</LogBufferManager>\n");
        return stats.toString();
    }

    int bsnFromMark(long mark) {
        return (int)(mark >> 24);
    }

    long markFromBsn(int bsn, int offset) {
        return (long)bsn << 24 | (long)offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getWaitForBuffer() {
        Object object = this.bufferManagerLock;
        synchronized (object) {
            return this.waitForBuffer;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ LogBuffer[] access$002(LogBufferManager x0, LogBuffer[] x1) {
        x0.freeBuffer = x1;
        return x1;
    }

    static /* synthetic */ LogBuffer[] access$602(LogBufferManager x0, LogBuffer[] x1) {
        x0.forceQueue = x1;
        return x1;
    }

    static {
        $assertionsDisabled = !(class$org$objectweb$howl$log$LogBufferManager == null ? (class$org$objectweb$howl$log$LogBufferManager = LogBufferManager.class$("org.objectweb.howl.log.LogBufferManager")) : class$org$objectweb$howl$log$LogBufferManager).desiredAssertionStatus();
    }

    class FlushManager
    extends Thread {
        FlushManager(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LogBuffer buffer = null;
            LogBufferManager parent = LogBufferManager.this;
            int flushSleepTime = LogBufferManager.this.config.getFlushSleepTime();
            long waitForBuffer = parent.getWaitForBuffer();
            while (!Thread.interrupted()) {
                try {
                    Thread.sleep(flushSleepTime);
                    long bufferWaits = parent.getWaitForBuffer() - waitForBuffer;
                    int maxBuffers = LogBufferManager.this.config.getMaxBuffers();
                    int increment = LogBufferManager.this.freeBuffer.length / 2;
                    if (maxBuffers > 0) {
                        maxBuffers = Math.max(maxBuffers, LogBufferManager.this.freeBuffer.length);
                        increment = Math.min(increment, maxBuffers - LogBufferManager.this.freeBuffer.length);
                    }
                    if (increment > 0 && bufferWaits > (long)increment) {
                        LogBuffer[] fb = new LogBuffer[LogBufferManager.this.freeBuffer.length + increment];
                        ++LogBufferManager.this.growPoolCounter;
                        boolean haveNewArray = true;
                        int i = LogBufferManager.this.freeBuffer.length;
                        while (i < fb.length) {
                            try {
                                fb[i] = LogBufferManager.this.getLogBuffer(i);
                            }
                            catch (ClassNotFoundException e) {
                                haveNewArray = false;
                                break;
                            }
                            ++i;
                        }
                        if (haveNewArray) {
                            LogBuffer[] fq = new LogBuffer[fb.length + 1];
                            Object object = LogBufferManager.this.bufferManagerLock;
                            synchronized (object) {
                                int i2 = 0;
                                while (i2 < LogBufferManager.this.freeBuffer.length) {
                                    fb[i2] = LogBufferManager.this.freeBuffer[i2];
                                    ++i2;
                                }
                                LogBufferManager.access$002(LogBufferManager.this, fb);
                                Object object2 = LogBufferManager.this.forceManagerLock;
                                synchronized (object2) {
                                    int fqx = 0;
                                    while (LogBufferManager.this.fqGet != LogBufferManager.this.fqPut) {
                                        fq[fqx++] = LogBufferManager.this.forceQueue[LogBufferManager.this.fqGet++];
                                        LogBufferManager.this.fqGet %= LogBufferManager.this.forceQueue.length;
                                    }
                                    LogBufferManager.access$602(LogBufferManager.this, fq);
                                    LogBufferManager.this.fqGet = 0;
                                    LogBufferManager.this.fqPut = fqx;
                                }
                            }
                        }
                    }
                    waitForBuffer = parent.getWaitForBuffer();
                    Object object = LogBufferManager.this.bufferManagerLock;
                    synchronized (object) {
                        buffer = LogBufferManager.this.fillBuffer;
                        if (buffer != null && buffer.shouldForce()) {
                            LogBufferManager.this.fillBuffer = null;
                            ((LogBufferManager)LogBufferManager.this).forceQueue[((LogBufferManager)LogBufferManager.this).fqPut] = buffer;
                            LogBufferManager.this.fqPut = (LogBufferManager.this.fqPut + 1) % LogBufferManager.this.forceQueue.length;
                        } else {
                            buffer = null;
                        }
                    }
                    if (buffer == null) continue;
                    LogBufferManager.this.force(true);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (IOException e) {
                    continue;
                }
                break;
            }
            return;
        }
    }
}

