/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.objectweb.howl.log.LogBuffer;

class LogFile {
    File file = null;
    FileChannel channel = null;
    int rewindCounter = 0;
    long bytesWritten = 0L;
    long highMark = Long.MIN_VALUE;
    int firstBSN = 0;
    long tod = 0L;
    long position = 0L;
    boolean newFile = true;

    LogFile(File file) {
        this.file = file;
    }

    LogFile open() throws FileNotFoundException {
        boolean bl = this.newFile = !this.file.exists();
        if (!this.newFile) {
            this.newFile = this.file.length() == 0L;
        }
        this.channel = new RandomAccessFile(this.file, "rw").getChannel();
        return this;
    }

    LogFile close() throws IOException {
        this.position = this.channel.position();
        this.channel.close();
        return this;
    }

    void write(LogBuffer lb) throws IOException {
        if (lb.rewind) {
            this.channel.position(0L);
            ++this.rewindCounter;
            lb.rewind = false;
        }
        this.bytesWritten += (long)this.channel.write(lb.buffer);
        this.position = this.channel.position();
    }

    void force(boolean forceMetadata) throws IOException {
        this.channel.force(forceMetadata);
    }

    String getStats() {
        String clsname = this.getClass().getName();
        StringBuffer result = new StringBuffer("\n<LogFile class='" + clsname + "' file='" + this.file + "'>" + "\n  <rewindCount value='" + this.rewindCounter + "'>Number of times this file was rewind to position(0)</rewindCount>" + "\n  <bytesWritten value='" + this.bytesWritten + "'>Number of bytes written to the file</bytesWritten>" + "\n  <position value='" + this.position + "'>FileChannel.position()</position>" + "\n</LogFile>" + "\n");
        return result.toString();
    }
}

