/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.objectweb.howl.log.LogConfigurationException;

public class Configuration {
    private final int MAX_BUFFERS_SIZE = 32;
    private Properties prop = null;
    private boolean listConfig = false;
    private boolean checksumEnabled = false;
    private int bufferSize = 4096;
    private String bufferClassName = "org.objectweb.howl.log.BlockLogBuffer";
    private int maxBuffers = 0;
    private int minBuffers = 4;
    private int flushSleepTime = 50;
    private int threadsWaitingForceThreshold = Integer.MAX_VALUE;
    int maxBlocksPerFile = Integer.MAX_VALUE;
    int maxLogFiles = 2;
    String logFileDir = "../logs";
    String logFileExt = "log";
    String logFileName = "logger";

    public Configuration() {
    }

    public Configuration(Properties prop) throws LogConfigurationException {
        this();
        this.prop = prop;
        this.parseProperties();
    }

    public Configuration(File propertyFile) throws LogConfigurationException {
        this();
        this.prop = new Properties();
        try {
            this.prop.load(new FileInputStream(propertyFile));
            this.parseProperties();
        }
        catch (FileNotFoundException e) {
            LogConfigurationException lce = new LogConfigurationException(e.toString());
            lce.initCause(e);
            throw lce;
        }
        catch (IOException e) {
            throw new LogConfigurationException(e.toString());
        }
    }

    private void showConfig(String key, int val, String text) {
        if (this.listConfig) {
            System.err.println(key + ": " + val + " " + text);
        }
    }

    private int getInteger(String key, int val, String text) {
        val = Integer.parseInt(this.prop.getProperty(key, Integer.toString(val)));
        this.showConfig(key, val, text);
        return val;
    }

    private int getInteger(String key, int val) {
        return this.getInteger(key, val, "");
    }

    private boolean getBoolean(String key, boolean val) throws LogConfigurationException {
        String pval = this.prop.getProperty(key, Boolean.toString(val)).toLowerCase();
        if (!pval.equals("true") && !pval.equals("false")) {
            throw new LogConfigurationException(key + "[" + pval + "] must be true of false");
        }
        val = Boolean.valueOf(pval);
        if (this.listConfig) {
            System.err.println(key + ": " + val);
        }
        return val;
    }

    private String getString(String key, String val) {
        val = this.prop.getProperty(key, val);
        if (this.listConfig) {
            System.err.println(key + ": " + val);
        }
        return val;
    }

    private void parseProperties() throws LogConfigurationException {
        Object val = null;
        Object key = null;
        this.listConfig = this.getBoolean("listConfig", this.listConfig);
        this.bufferClassName = this.getString("bufferClassName", this.bufferClassName);
        this.bufferSize = this.getInteger("bufferSize", this.bufferSize / 1024, "Kb");
        if (this.bufferSize < 1 || this.bufferSize > this.MAX_BUFFERS_SIZE) {
            throw new LogConfigurationException("bufferSize [" + this.bufferSize + "] must be" + " between 1 and " + this.MAX_BUFFERS_SIZE);
        }
        this.bufferSize *= 1024;
        this.showConfig("bufferSize", this.bufferSize, "bytes");
        this.checksumEnabled = this.getBoolean("checksumEnabled", this.checksumEnabled);
        this.flushSleepTime = this.getInteger("flushSleepTime", this.flushSleepTime);
        this.logFileDir = this.getString("logFileDir", this.logFileDir);
        this.logFileExt = this.getString("logFileExt", this.logFileExt);
        this.logFileName = this.getString("logFileName", this.logFileName);
        this.maxBlocksPerFile = this.getInteger("maxBlocksPerFile", this.maxBlocksPerFile);
        this.minBuffers = this.getInteger("minBuffers", this.minBuffers);
        this.maxBuffers = this.getInteger("maxBuffers", this.maxBuffers);
        this.maxLogFiles = this.getInteger("maxLogFiles", this.maxLogFiles);
        this.threadsWaitingForceThreshold = this.getInteger("threadsWaitingForceThreshold", this.threadsWaitingForceThreshold);
        if (this.maxBuffers > 0 && this.maxBuffers < this.minBuffers) {
            throw new LogConfigurationException("minBuffers [" + this.minBuffers + "] must be <= than maxBuffers[" + this.maxBuffers + "]");
        }
        if (this.minBuffers <= 0) {
            throw new LogConfigurationException("minBuffers[" + this.minBuffers + "] must be > 0");
        }
    }

    public String getLogFileDir() {
        return this.logFileDir;
    }

    public void setLogFileDir(String logDir) {
        this.logFileDir = logDir;
    }

    public String getLogFileExt() {
        return this.logFileExt;
    }

    public void setLogFileExt(String logFileExt) {
        this.logFileExt = logFileExt;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public boolean isChecksumEnabled() {
        return this.checksumEnabled;
    }

    public void setChecksumEnabled(boolean checksumOption) {
        this.checksumEnabled = checksumOption;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize * 1024;
    }

    public String getBufferClassName() {
        return this.bufferClassName;
    }

    public void setBufferClassName(String bufferClassName) {
        this.bufferClassName = bufferClassName;
    }

    public int getMaxBuffers() {
        return this.maxBuffers;
    }

    public void setMaxBuffers(int maxBuffers) {
        this.maxBuffers = maxBuffers;
    }

    public int getMinBuffers() {
        return this.minBuffers;
    }

    public void setMinBuffers(int minBuffers) {
        this.minBuffers = minBuffers;
    }

    public int getFlushSleepTime() {
        return this.flushSleepTime;
    }

    public void setFlushSleepTime(int flushSleepTime) {
        this.flushSleepTime = flushSleepTime;
    }

    public int getThreadsWaitingForceThreshold() {
        return this.threadsWaitingForceThreshold;
    }

    public void setThreadsWaitingForceThreshold(int threadsWaitingForceThreshold) {
        this.threadsWaitingForceThreshold = threadsWaitingForceThreshold;
    }

    public int getMaxBlocksPerFile() {
        return this.maxBlocksPerFile;
    }

    public void setMaxBlocksPerFile(int maxBlocksPerFile) {
        this.maxBlocksPerFile = maxBlocksPerFile;
    }

    public int getMaxLogFiles() {
        return this.maxLogFiles;
    }

    public void setMaxLogFiles(int maxLogFiles) {
        this.maxLogFiles = maxLogFiles;
    }
}

