/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.test;

import java.io.File;
import java.util.Date;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.LogClosedException;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.Logger;
import org.objectweb.howl.log.ReplayListener;
import org.objectweb.howl.test.Barrier;

public class LogTest {
    File journalFile = null;
    Barrier startBarrier;
    Barrier stopBarrier;
    int startedThreads = 0;
    int stoppedThreads = 0;
    int runningThreads = 0;
    int MESSAGE_COUNT = 0;
    int MESSAGE_SIZE = 0;
    int WORKERS = 0;
    Logger log = null;
    final Object mutex = new Object();
    long totalBytes = 0L;
    long totalLatency = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        try {
            this.testXAJournalThroughput();
            this.testXAJournalValidate();
        }
        catch (LogException e) {
            System.err.println("LogException\n");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Exception\n");
            e.printStackTrace();
        }
        catch (AssertionError e) {
            System.err.println("AssertionError\n");
            ((Throwable)((Object)e)).printStackTrace();
        }
        finally {
            System.out.println(this.log.getStats());
        }
    }

    public static void main(String[] args) {
        new LogTest().run();
    }

    public void testXAJournalThroughput() throws Exception, LogException {
        Configuration cfg = new Configuration(new File("conf/log.properties"));
        this.log = new Logger(cfg);
        this.log.open();
        this.log.setAutoMark(Boolean.getBoolean("howl.log.test.setautomark"));
        this.WORKERS = Integer.getInteger("xa.workers", 1);
        this.MESSAGE_COUNT = Integer.getInteger("xa.msg.count", 5);
        this.MESSAGE_SIZE = Integer.getInteger("xa.msg.size", 80);
        this.startBarrier = new Barrier(this.WORKERS + 1);
        this.stopBarrier = new Barrier(this.WORKERS + 1);
        long beginTime = System.currentTimeMillis();
        System.err.println("Start test:\n  WORKERS (xa.workers): " + this.WORKERS + "\n  MESSAGE_COUNT (xa.msg.count): " + this.MESSAGE_COUNT + "\n  MESSAGE_SIZE (xa.msg.size): " + this.MESSAGE_SIZE + "\n");
        String testName = "testXAJournalThroughput";
        long startTime = this.journalTest(this.log, testName);
        this.log.close();
        long stopTime = System.currentTimeMillis();
        System.err.println(testName + ":");
        this.printSpeedReport(this.log, startTime, stopTime);
        long endTime = System.currentTimeMillis();
        System.err.println("End test: elapsed time " + (endTime - beginTime) + " ms");
    }

    public void testXAJournalValidate() throws Exception, LogException {
        System.err.println("Begin Journal Validation");
        LogReader reader = new LogReader();
        reader.run();
        System.err.println("End Journal Validation; total records processed: " + reader.recordCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long journalTest(final Logger logger, String testName) throws Exception {
        for (int i = 0; i < this.WORKERS; ++i) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block39: {
                        boolean exception;
                        long latency;
                        long bytes;
                        block37: {
                            bytes = 0L;
                            Date today = new Date();
                            latency = 0L;
                            exception = false;
                            LogTest.this.startBarrier.barrier();
                            byte[] data = new byte[LogTest.this.MESSAGE_SIZE];
                            byte[][] dataRec = new byte[][]{data};
                            for (int i = 0; i < LogTest.this.MESSAGE_SIZE; ++i) {
                                data[i] = (byte)(32 + i % 94);
                            }
                            data[LogTest.this.MESSAGE_SIZE - 2] = 13;
                            data[LogTest.this.MESSAGE_SIZE - 1] = 10;
                            String threadName = "[xxxx]COMMIT:" + Thread.currentThread().getName() + " ";
                            int tnl = threadName.length();
                            if (tnl < data.length) {
                                System.arraycopy(threadName.getBytes(), 0, data, 0, tnl);
                            }
                            byte[] donerec = ("[xxxx]DONE  :" + Thread.currentThread().getName() + "\n").getBytes();
                            byte[][] donerecRec = new byte[][]{donerec};
                            boolean doTimeStamp = Boolean.getBoolean("howl.log.test.timeStamp");
                            for (int i = 0; i < LogTest.this.MESSAGE_COUNT; ++i) {
                                byte[] now;
                                long latencyStart = System.currentTimeMillis();
                                int msg = i;
                                for (int j = 4; j > 0; --j) {
                                    data[j] = (byte)(48 + msg % 10);
                                    msg /= 10;
                                }
                                if (doTimeStamp && (now = new Date().toString().getBytes()).length < data.length - tnl) {
                                    System.arraycopy(now, 0, data, tnl, now.length);
                                }
                                logger.put(dataRec, true);
                                bytes += (long)data.length;
                                System.arraycopy(data, 1, donerec, 1, 4);
                                logger.put(donerecRec, false);
                                bytes += (long)donerec.length;
                                latency += System.currentTimeMillis() - latencyStart;
                            }
                            Object var20_21 = null;
                            if (!exception) break block37;
                            try {
                                logger.close();
                            }
                            catch (LogException e2) {
                                exception = true;
                            }
                            catch (Exception e2) {
                                exception = true;
                            }
                        }
                        Object object = LogTest.this.mutex;
                        synchronized (object) {
                            LogTest.this.totalBytes += bytes;
                            LogTest.this.totalLatency += latency;
                        }
                        LogTest.this.stopBarrier.release();
                        {
                            break block39;
                            catch (LogClosedException e) {
                                Object var20_22 = null;
                                if (exception) {
                                    try {
                                        logger.close();
                                    }
                                    catch (LogException e2) {
                                        exception = true;
                                    }
                                    catch (Exception e2) {
                                        exception = true;
                                    }
                                }
                                Object object2 = LogTest.this.mutex;
                                synchronized (object2) {
                                    LogTest.this.totalBytes += bytes;
                                    LogTest.this.totalLatency += latency;
                                }
                                LogTest.this.stopBarrier.release();
                                break block39;
                            }
                            catch (LogException e) {
                                System.err.println(Thread.currentThread().getName());
                                e.printStackTrace(System.err);
                                exception = true;
                                Object var20_23 = null;
                                if (exception) {
                                    try {
                                        logger.close();
                                    }
                                    catch (LogException e2) {
                                        exception = true;
                                    }
                                    catch (Exception e2) {
                                        exception = true;
                                    }
                                }
                                Object object3 = LogTest.this.mutex;
                                synchronized (object3) {
                                    LogTest.this.totalBytes += bytes;
                                    LogTest.this.totalLatency += latency;
                                }
                                LogTest.this.stopBarrier.release();
                                break block39;
                            }
                            catch (Exception e) {
                                System.err.println(Thread.currentThread().getName());
                                e.printStackTrace(System.err);
                                exception = true;
                                Object var20_24 = null;
                                if (exception) {
                                    try {
                                        logger.close();
                                    }
                                    catch (LogException e2) {
                                        exception = true;
                                    }
                                    catch (Exception e2) {
                                        exception = true;
                                    }
                                }
                                Object object4 = LogTest.this.mutex;
                                synchronized (object4) {
                                    LogTest.this.totalBytes += bytes;
                                    LogTest.this.totalLatency += latency;
                                }
                                LogTest.this.stopBarrier.release();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var20_25 = null;
                            if (exception) {
                                try {
                                    logger.close();
                                }
                                catch (LogException e2) {
                                    exception = true;
                                }
                                catch (Exception e2) {
                                    exception = true;
                                }
                            }
                            Object object5 = LogTest.this.mutex;
                            synchronized (object5) {
                                LogTest.this.totalBytes += bytes;
                                LogTest.this.totalLatency += latency;
                            }
                            LogTest.this.stopBarrier.release();
                            throw throwable;
                        }
                    }
                }
            }.start();
        }
        long startTime = 0L;
        Barrier barrier = this.startBarrier;
        synchronized (barrier) {
            while (this.startBarrier.getCount() > 1) {
                this.startBarrier.wait();
            }
            startTime = System.currentTimeMillis();
            this.startBarrier.barrier();
        }
        System.err.println("HardenerTest.journalTest(): " + this.WORKERS + " threads started");
        this.stopBarrier.barrier();
        return startTime;
    }

    void printSpeedReport(Logger journal, long startTime, long stopTime) {
        long mc = (long)this.MESSAGE_COUNT * 2L * (long)this.WORKERS;
        float kb = (float)this.totalBytes / 1024.0f;
        long duration = stopTime - startTime;
        long avgLatency = this.totalLatency / (long)(this.MESSAGE_COUNT * this.WORKERS);
        System.err.println(" wrote: " + mc + " messages in " + duration + " ms. (" + mc * 1000L / duration + " m/s)");
        System.err.println(" wrote: " + kb + " kb in " + duration + " ms. (" + kb * 1000.0f / (float)duration + " kb/s)");
        System.err.println(" average latency: " + avgLatency + " ms.");
    }

    class LogReader
    implements ReplayListener {
        LogRecord logrec;
        long recordCount;
        long previousKey;
        boolean done;

        LogReader() {
            this.logrec = new LogRecord(LogTest.this.MESSAGE_SIZE);
            this.recordCount = 0L;
            this.previousKey = 0L;
            this.done = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRecord(LogRecord lr) {
            if (lr.type == 19983) {
                LogReader logReader = this;
                synchronized (logReader) {
                    this.done = true;
                    this.notify();
                }
            } else {
                ++this.recordCount;
                if (lr.key <= this.previousKey) {
                    System.err.println("Key Out of Sequence; total/prev/this: " + this.recordCount + " / " + Long.toHexString(this.previousKey) + " / " + Long.toHexString(lr.key));
                }
            }
        }

        public void onError(LogException e) {
            System.err.println(e);
            e.printStackTrace();
        }

        public LogRecord getLogRecord() {
            return this.logrec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run() throws Exception, LogException {
            Configuration cfg = new Configuration(new File("conf/log.properties"));
            Logger log = new Logger(cfg);
            log.open();
            log.replay(this, 0L);
            log.close();
            LogReader logReader = this;
            synchronized (logReader) {
                while (!this.done) {
                    this.wait();
                }
            }
        }
    }
}

