/*
 * Decompiled with CFR 0.152.
 */
package com.vgv.excel.io;

import com.vgv.excel.io.Style;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public interface ECell {
    public Cell attachTo(Row var1);

    public ECell with(Style var1);

    public static final class WithStyle
    implements ECell {
        private final ECell origin;
        private final LinkedList<Style> styles;

        public WithStyle(ECell cell, Style style) {
            this(cell, new LinkedList<Style>(Collections.singletonList(style)));
        }

        public WithStyle(ECell cell, Collection<Style> styls) {
            this.origin = cell;
            this.styles = new LinkedList<Style>(styls);
        }

        @Override
        public Cell attachTo(Row row) {
            Cell cell = this.origin.attachTo(row);
            cell.setCellStyle(row.getSheet().getWorkbook().createCellStyle());
            for (Style style : this.styles) {
                style.attachTo(cell);
            }
            return cell;
        }

        @Override
        public ECell with(Style style) {
            this.styles.addFirst(style);
            return new WithStyle((ECell)this, this.styles);
        }
    }
}

