/*
 * Decompiled with CFR 0.152.
 */
package com.vgv.excel.io;

import com.jcabi.immutable.Array;
import com.vgv.excel.io.ECell;
import com.vgv.excel.io.ECells;
import com.vgv.excel.io.ERow;
import com.vgv.excel.io.Props;
import com.vgv.excel.io.Style;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public final class XsRow
implements ERow {
    private final int index;
    private final Array<ECell> cells;

    public XsRow(ECell ... elements) {
        this((Iterable<ECell>)new Array((Object[])elements));
    }

    public XsRow(int position, ECell ... elements) {
        this(position, (Iterable<ECell>)new Array((Object[])elements));
    }

    public XsRow(Iterable<ECell> elements) {
        this(-1, (Iterable<ECell>)new Array(elements));
    }

    public XsRow(int position, Iterable<ECell> elements) {
        this.index = position;
        this.cells = new Array(elements);
    }

    @Override
    public Row attachTo(Sheet sheet) {
        Row row = this.createRow(sheet);
        for (ECell cell : this.cells) {
            cell.attachTo(row);
        }
        return row;
    }

    @Override
    public ERow with(Style style) {
        ArrayList<ECell> elements = new ArrayList<ECell>(this.cells.size());
        for (ECell cell : this.cells) {
            elements.add(cell.with(style));
        }
        return new XsRow(elements);
    }

    @Override
    public ERow with(ECell ... elements) {
        return new XsRow((Iterable<ECell>)this.cells.with((Iterable)new Array((Object[])elements)));
    }

    @Override
    public ERow with(ECells elements) {
        return new XsRow((Iterable<ECell>)this.cells.with(elements.asArray()));
    }

    @Override
    public WithProps with(Props<Row> props) {
        return new WithProps(this, props);
    }

    private Row createRow(Sheet sheet) {
        Row row;
        if (this.index == -1) {
            int num = sheet.getLastRowNum();
            row = sheet.createRow(num);
            sheet.createRow(num + 1);
        } else {
            row = sheet.getRow(this.index - 1);
            if (row == null) {
                row = sheet.createRow(this.index - 1);
            }
        }
        return row;
    }

    public static final class WithProps
    implements ERow {
        private final ERow origin;
        private final Props<Row> props;

        public WithProps(ERow row, Props<Row> properties) {
            this.origin = row;
            this.props = properties;
        }

        @Override
        public Row attachTo(Sheet sheet) {
            Row row = this.origin.attachTo(sheet);
            this.props.accept(row);
            return row;
        }

        @Override
        public ERow with(Style style) {
            return this.origin.with(style);
        }

        @Override
        public ERow with(ECell ... cells) {
            return this.origin.with(cells);
        }

        @Override
        public ERow with(ECells cells) {
            return this.origin.with(cells);
        }

        @Override
        public ERow with(Props<Row> properties) {
            return this;
        }
    }
}

