/*
 * Decompiled with CFR 0.152.
 */
package com.vgv.excel.io;

import com.jcabi.immutable.Array;
import com.vgv.excel.io.ERow;
import com.vgv.excel.io.ESheet;
import com.vgv.excel.io.Props;
import com.vgv.excel.io.Style;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.cactoos.Func;
import org.cactoos.func.IoCheckedFunc;

public final class XsSheet
implements ESheet {
    private final Array<ERow> rows;
    private final String name;

    public XsSheet(String title) {
        this(title, (Iterable<ERow>)new Array());
    }

    public XsSheet(ERow ... elements) {
        this("", (Iterable<ERow>)new Array((Object[])elements));
    }

    public XsSheet(String title, ERow ... elements) {
        this(title, (Iterable<ERow>)new Array((Object[])elements));
    }

    public XsSheet(String title, Iterable<ERow> elements) {
        this.name = title;
        this.rows = new Array(elements);
    }

    @Override
    public Sheet attachTo(Workbook workbook) {
        Sheet sheet = this.name.isEmpty() ? workbook.createSheet() : workbook.createSheet(this.name);
        for (ERow row : this.rows) {
            row.attachTo(sheet);
        }
        return sheet;
    }

    @Override
    public ESheet with(ERow element) {
        return new XsSheet(this.name, (Iterable<ERow>)this.rows.with((Object)element));
    }

    @Override
    public ESheet with(Style style) {
        ArrayList<ERow> elements = new ArrayList<ERow>(this.rows.size());
        for (ERow row : this.rows) {
            elements.add(row.with(style));
        }
        return new XsSheet(this.name, elements);
    }

    public WithProps with(Props<Sheet> props) {
        return new WithProps(this, props);
    }

    public static final class ReadFrom
    implements ESheet {
        private final Func<Workbook, Sheet> func;
        private final Array<ERow> rows;

        public ReadFrom(String title) {
            this((Func<Workbook, Sheet>)((Func)workbook -> workbook.getSheet(title)), (Iterable<ERow>)new Array());
        }

        public ReadFrom(int index) {
            this((Func<Workbook, Sheet>)((Func)workbook -> workbook.getSheetAt(index)), (Iterable<ERow>)new Array());
        }

        public ReadFrom(Func<Workbook, Sheet> function, Iterable<ERow> elements) {
            this.func = function;
            this.rows = new Array(elements);
        }

        @Override
        public Sheet attachTo(Workbook workbook) throws IOException {
            Sheet sheet = (Sheet)new IoCheckedFunc(this.func).apply((Object)workbook);
            if (sheet == null) {
                throw new IOException("Sheet not found on specified index");
            }
            for (ERow row : this.rows) {
                row.attachTo(sheet);
            }
            return sheet;
        }

        @Override
        public ESheet with(ERow row) {
            return new ReadFrom(this.func, (Iterable<ERow>)this.rows.with((Object)row));
        }

        @Override
        public ESheet with(Style style) {
            ArrayList<ERow> elements = new ArrayList<ERow>(this.rows.size());
            for (ERow row : this.rows) {
                elements.add(row.with(style));
            }
            return new ReadFrom(this.func, elements);
        }
    }

    public static final class WithProps
    implements ESheet {
        private final ESheet origin;
        private final Props<Sheet> props;

        public WithProps(ESheet sheet, Props<Sheet> properties) {
            this.origin = sheet;
            this.props = properties;
        }

        @Override
        public Sheet attachTo(Workbook workbook) throws IOException {
            Sheet sheet = this.origin.attachTo(workbook);
            this.props.accept(sheet);
            return sheet;
        }

        @Override
        public ESheet with(ERow row) {
            return this.origin.with(row);
        }

        @Override
        public ESheet with(Style style) {
            return this.origin.with(style);
        }
    }
}

