/*
 * Decompiled with CFR 0.152.
 */
package com.vgv.excel.io;

import com.jcabi.immutable.Array;
import com.vgv.excel.io.ESheet;
import com.vgv.excel.io.EWorkbook;
import com.vgv.excel.io.Style;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.cactoos.Scalar;
import org.cactoos.scalar.IoCheckedScalar;

public final class XsWorkbook
implements EWorkbook {
    private final Array<ESheet> sheets;
    private final IoCheckedScalar<Workbook> workbook;

    public XsWorkbook(Iterable<ESheet> elements) {
        this(elements, (Scalar<Workbook>)((Scalar)XSSFWorkbook::new));
    }

    public XsWorkbook(ESheet ... elements) {
        this((Iterable<ESheet>)new Array((Object[])elements), (Scalar<Workbook>)((Scalar)XSSFWorkbook::new));
    }

    public XsWorkbook(String path) {
        this(new File(path));
    }

    public XsWorkbook(File file) {
        this((Iterable<ESheet>)new Array(), (Scalar<Workbook>)((Scalar)() -> new XSSFWorkbook((InputStream)new FileInputStream(file))));
    }

    public XsWorkbook(InputStream stream) {
        this((Iterable<ESheet>)new Array(), (Scalar<Workbook>)((Scalar)() -> new XSSFWorkbook(stream)));
    }

    public XsWorkbook(Iterable<ESheet> elements, Scalar<Workbook> scalar) {
        this.sheets = new Array(elements);
        this.workbook = new IoCheckedScalar(scalar);
    }

    @Override
    public ByteArrayOutputStream asStream() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (Workbook wbook = (Workbook)this.workbook.value();){
            this.attachSheets(wbook);
            wbook.write((OutputStream)stream);
        }
        return stream;
    }

    @Override
    public Workbook asWorkbook() throws IOException {
        Workbook wbook = (Workbook)this.workbook.value();
        this.attachSheets(wbook);
        return wbook;
    }

    @Override
    public void saveTo(String path) throws IOException {
        try (FileOutputStream file = new FileOutputStream(path);
             Workbook wbook = (Workbook)this.workbook.value();){
            this.attachSheets(wbook);
            wbook.write((OutputStream)file);
            file.flush();
        }
    }

    @Override
    public EWorkbook with(ESheet sheet) {
        return new XsWorkbook((Iterable<ESheet>)this.sheets.with((Object)sheet), (Scalar<Workbook>)this.workbook);
    }

    @Override
    public EWorkbook with(Style style) {
        ArrayList<ESheet> elements = new ArrayList<ESheet>(this.sheets.size());
        for (ESheet sheet : this.sheets) {
            elements.add(sheet.with(style));
        }
        return new XsWorkbook((Iterable<ESheet>)elements, (Scalar<Workbook>)this.workbook);
    }

    private void attachSheets(Workbook wbook) throws IOException {
        for (ESheet sheet : this.sheets) {
            sheet.attachTo(wbook);
        }
    }
}

