/*
 * Decompiled with CFR 0.152.
 */
package com.vgv.excel.io.cells;

import com.vgv.excel.io.ECell;
import com.vgv.excel.io.Style;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public final class EmptyCell
implements ECell {
    private final int position;

    public EmptyCell() {
        this(-1);
    }

    public EmptyCell(int column) {
        this.position = column;
    }

    @Override
    public Cell attachTo(Row row) {
        Cell cell;
        if (this.position == -1) {
            cell = EmptyCell.createCell(row.getLastCellNum(), row);
        } else {
            cell = row.getCell(this.position - 1);
            if (cell == null) {
                cell = EmptyCell.createCell(this.position - 1, row);
            }
        }
        return cell;
    }

    @Override
    public ECell with(Style style) {
        return new ECell.WithStyle((ECell)this, style);
    }

    private static Cell createCell(int position, Row row) {
        int index = position < 0 ? 0 : position;
        return row.createCell(index);
    }
}

