/*
 * Decompiled with CFR 0.152.
 */
package hu.advancedweb.maven;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="prepare-agent", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class ScottAgentMojo
extends AbstractMojo {
    private static final String SCOTT_ARTIFACT_NAME = "hu.advancedweb:scott";
    private static final String ARG_LINE = "argLine";
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="plugin.artifactMap", required=true, readonly=true)
    Map<String, Artifact> pluginArtifactMap;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties projectProperties = this.project.getProperties();
        File agentJarFile = this.pluginArtifactMap.get(SCOTT_ARTIFACT_NAME).getFile();
        String arguments = this.getArgument(agentJarFile);
        this.getLog().info((CharSequence)("argLine set to " + arguments));
        projectProperties.setProperty(ARG_LINE, arguments);
    }

    private String getArgument(File agentJarFile) {
        return String.format("-javaagent:%s", agentJarFile);
    }
}

