/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.bannersnatch;

import hu.blackbelt.bannersnatch.color.Hsl;
import hu.blackbelt.bannersnatch.color.Rgb;
import hu.blackbelt.bannersnatch.color.TermColor;
import hu.blackbelt.bannersnatch.figlet.FigFont;
import hu.blackbelt.bannersnatch.figlet.FigFontResources;
import hu.blackbelt.bannersnatch.figlet.FigletRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class Banner {
    static Random random = new Random();
    TermColor.TermColorModel termColorModel;
    boolean isGrayscale;
    String fontName;

    public String drawPalette(int cols, int rows) {
        StringBuilder sb = new StringBuilder();
        sb.append(TermColor.RESET);
        for (int l = 0; l < rows; ++l) {
            for (int h = 0; h < cols; ++h) {
                Rgb rgb = new Hsl(1.0 / (double)cols * (double)h, 1.0, (double)(l + 1) / (double)rows).toRgb();
                sb.append(rgb.toTerminalColor().toAnsiSequence(this.termColorModel, false, this.isGrayscale));
                sb.append("\u2588");
            }
            sb.append("\n");
        }
        sb.append(TermColor.RESET);
        return sb.toString();
    }

    public String drawAscii(String text) {
        try {
            FigFont figFont = FigFontResources.loadFigFontResource(this.fontName);
            FigletRenderer figletRenderer = new FigletRenderer(figFont);
            return figletRenderer.renderText(text);
        }
        catch (IOException e) {
            return text;
        }
    }

    public String drawColor(String text, Hsl hsl) {
        return this.colorize(this.drawAscii(text), hsl, hsl);
    }

    public String drawColor(String text, Rgb rgb) {
        return this.colorize(this.drawAscii(text), rgb.toHsl(), rgb.toHsl());
    }

    public String drawColorRange(String text, Hsl hslStart, Hsl hslEnd) {
        return this.colorize(this.drawAscii(text), hslStart, hslEnd);
    }

    public String drawColorRange(String text, Rgb rgbStart, Rgb rgbEnd) {
        return this.colorize(this.drawAscii(text), rgbStart.toHsl(), rgbEnd.toHsl());
    }

    public String drawCrazy(String text) {
        ArrayList<String> fonts = new ArrayList<String>(FigFontResources.FONTS);
        String fontNameReplacement = (String)fonts.get(random.nextInt(fonts.size() - 1));
        Banner figletColorRenderer = Banner.bannerBuilder().fontName(fontNameReplacement).termColorModel(this.termColorModel).isGrayscale(this.isGrayscale).build();
        Hsl hslStart = new Hsl(Math.random(), Math.random(), Math.random());
        Hsl hslEnd = new Hsl(Math.random(), Math.random(), Math.random());
        return figletColorRenderer.drawColorRange(text, hslStart, hslEnd);
    }

    public String colorize(String ascii, Hsl hslStart, Hsl hslEnd) {
        String[] artLines = ascii.split("\n");
        double inc = 1.0 / (double)artLines.length;
        double pos = 0.0;
        StringBuilder builder = new StringBuilder();
        builder.append(TermColor.RESET);
        for (String s : artLines) {
            builder.append(hslStart.interpolate(hslEnd, pos).toTerminalColor().toAnsiSequence(this.termColorModel, false, this.isGrayscale));
            builder.append(s);
            builder.append("\n");
            pos += inc;
        }
        builder.append(TermColor.RESET);
        return builder.toString();
    }

    private static TermColor.TermColorModel $default$termColorModel() {
        return TermColor.TermColorModel.COLOR_256;
    }

    private static boolean $default$isGrayscale() {
        return false;
    }

    private static String $default$fontName() {
        return "Standard.flf";
    }

    Banner(TermColor.TermColorModel termColorModel, boolean isGrayscale, String fontName) {
        this.termColorModel = termColorModel;
        this.isGrayscale = isGrayscale;
        this.fontName = fontName;
    }

    public static BannerBuilder bannerBuilder() {
        return new BannerBuilder();
    }

    public static class BannerBuilder {
        private boolean termColorModel$set;
        private TermColor.TermColorModel termColorModel$value;
        private boolean isGrayscale$set;
        private boolean isGrayscale$value;
        private boolean fontName$set;
        private String fontName$value;

        BannerBuilder() {
        }

        public BannerBuilder termColorModel(TermColor.TermColorModel termColorModel) {
            this.termColorModel$value = termColorModel;
            this.termColorModel$set = true;
            return this;
        }

        public BannerBuilder isGrayscale(boolean isGrayscale) {
            this.isGrayscale$value = isGrayscale;
            this.isGrayscale$set = true;
            return this;
        }

        public BannerBuilder fontName(String fontName) {
            this.fontName$value = fontName;
            this.fontName$set = true;
            return this;
        }

        public Banner build() {
            TermColor.TermColorModel termColorModel$value = this.termColorModel$value;
            if (!this.termColorModel$set) {
                termColorModel$value = Banner.$default$termColorModel();
            }
            boolean isGrayscale$value = this.isGrayscale$value;
            if (!this.isGrayscale$set) {
                isGrayscale$value = Banner.$default$isGrayscale();
            }
            String fontName$value = this.fontName$value;
            if (!this.fontName$set) {
                fontName$value = Banner.$default$fontName();
            }
            return new Banner(termColorModel$value, isGrayscale$value, fontName$value);
        }

        public String toString() {
            return "Banner.BannerBuilder(termColorModel$value=" + (Object)((Object)this.termColorModel$value) + ", isGrayscale$value=" + this.isGrayscale$value + ", fontName$value=" + this.fontName$value + ")";
        }
    }
}

