/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.bannersnatch;

import hu.blackbelt.bannersnatch.color.Rgb;
import hu.blackbelt.bannersnatch.color.TermColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageToText {
    boolean isColorConverted;
    boolean useGrayRamp;
    int width;
    double aspectRatio;
    boolean isGraycale;
    String customGrayRamp;
    GrayRampType grayRampType;
    TermColor.TermColorModel termColorModel;
    int transparentColor;

    private BufferedImage resizeImage(BufferedImage originalImage, int targetWidth, int targetHeight) {
        BufferedImage resizedImage = new BufferedImage(targetWidth, targetHeight, 1);
        Graphics2D graphics2D = resizedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(originalImage, 0, 0, targetWidth, targetHeight, null);
        graphics2D.dispose();
        return resizedImage;
    }

    public String convertImage(InputStream image) {
        BufferedImage img;
        try {
            img = ImageIO.read(image);
        }
        catch (IOException e) {
            return "Could not load image";
        }
        img = this.resizeImage(img, this.width, (int)((double)img.getHeight() * ((double)this.width / (double)img.getHeight()) * this.aspectRatio));
        StringBuilder sb = new StringBuilder();
        sb.append(TermColor.RESET);
        for (int i = 0; i < img.getHeight(); ++i) {
            this.convertLine(img, sb, i);
        }
        sb.append(TermColor.RESET);
        return sb.toString();
    }

    private void convertLine(BufferedImage img, StringBuilder sb, int i) {
        String lastRgbSeq = "";
        for (int j = 0; j < img.getWidth(); ++j) {
            Rgb rgb;
            Color pixcol = new Color(img.getRGB(j, i));
            String rgbSeq = this.getEffectiveRgbSeq(pixcol, rgb = new Rgb(pixcol.getRGB()));
            if (!rgbSeq.equals("") && !rgbSeq.equals(lastRgbSeq)) {
                sb.append(rgbSeq);
                lastRgbSeq = rgbSeq;
            }
            this.drawPixel(pixcol, sb);
        }
        sb.append("\n");
    }

    private String getEffectiveRgbSeq(Color pixcol, Rgb rgb) {
        if (this.isColorConverted && pixcol.getAlpha() > 0) {
            return rgb.toTerminalColor().toAnsiSequence(this.termColorModel, false, this.isGraycale);
        }
        return "";
    }

    private void drawPixel(Color pixcol, StringBuilder sb) {
        Rgb rgb = new Rgb(pixcol.getRGB());
        if (pixcol.getAlpha() > 0 && rgb.toTerminalColor().getColorCode(this.termColorModel, this.isGraycale) != this.transparentColor) {
            if (this.useGrayRamp) {
                sb.append(this.strChar(255 - rgb.toGrayscale().r));
            } else {
                sb.append("\u2588");
            }
        } else {
            sb.append(' ');
        }
    }

    private char getCharacterForGrayScale(int grayScale) {
        String grayRamp = this.grayRampType.getRamp();
        if (this.customGrayRamp != null && !this.customGrayRamp.trim().equals("")) {
            grayRamp = this.customGrayRamp;
        }
        return grayRamp.charAt((grayRamp.length() - 1) * grayScale / 255);
    }

    private char strChar(int g) {
        return this.getCharacterForGrayScale(g);
    }

    private static boolean $default$isColorConverted() {
        return true;
    }

    private static boolean $default$useGrayRamp() {
        return true;
    }

    private static int $default$width() {
        return 80;
    }

    private static double $default$aspectRatio() {
        return 0.75;
    }

    private static boolean $default$isGraycale() {
        return false;
    }

    private static String $default$customGrayRamp() {
        return "";
    }

    private static GrayRampType $default$grayRampType() {
        return GrayRampType.STANDARD;
    }

    private static TermColor.TermColorModel $default$termColorModel() {
        return TermColor.TermColorModel.COLOR_256;
    }

    private static int $default$transparentColor() {
        return -1;
    }

    ImageToText(boolean isColorConverted, boolean useGrayRamp, int width, double aspectRatio, boolean isGraycale, String customGrayRamp, GrayRampType grayRampType, TermColor.TermColorModel termColorModel, int transparentColor) {
        this.isColorConverted = isColorConverted;
        this.useGrayRamp = useGrayRamp;
        this.width = width;
        this.aspectRatio = aspectRatio;
        this.isGraycale = isGraycale;
        this.customGrayRamp = customGrayRamp;
        this.grayRampType = grayRampType;
        this.termColorModel = termColorModel;
        this.transparentColor = transparentColor;
    }

    public static ImageToTextBuilder builder() {
        return new ImageToTextBuilder();
    }

    public static class ImageToTextBuilder {
        private boolean isColorConverted$set;
        private boolean isColorConverted$value;
        private boolean useGrayRamp$set;
        private boolean useGrayRamp$value;
        private boolean width$set;
        private int width$value;
        private boolean aspectRatio$set;
        private double aspectRatio$value;
        private boolean isGraycale$set;
        private boolean isGraycale$value;
        private boolean customGrayRamp$set;
        private String customGrayRamp$value;
        private boolean grayRampType$set;
        private GrayRampType grayRampType$value;
        private boolean termColorModel$set;
        private TermColor.TermColorModel termColorModel$value;
        private boolean transparentColor$set;
        private int transparentColor$value;

        ImageToTextBuilder() {
        }

        public ImageToTextBuilder isColorConverted(boolean isColorConverted) {
            this.isColorConverted$value = isColorConverted;
            this.isColorConverted$set = true;
            return this;
        }

        public ImageToTextBuilder useGrayRamp(boolean useGrayRamp) {
            this.useGrayRamp$value = useGrayRamp;
            this.useGrayRamp$set = true;
            return this;
        }

        public ImageToTextBuilder width(int width) {
            this.width$value = width;
            this.width$set = true;
            return this;
        }

        public ImageToTextBuilder aspectRatio(double aspectRatio) {
            this.aspectRatio$value = aspectRatio;
            this.aspectRatio$set = true;
            return this;
        }

        public ImageToTextBuilder isGraycale(boolean isGraycale) {
            this.isGraycale$value = isGraycale;
            this.isGraycale$set = true;
            return this;
        }

        public ImageToTextBuilder customGrayRamp(String customGrayRamp) {
            this.customGrayRamp$value = customGrayRamp;
            this.customGrayRamp$set = true;
            return this;
        }

        public ImageToTextBuilder grayRampType(GrayRampType grayRampType) {
            this.grayRampType$value = grayRampType;
            this.grayRampType$set = true;
            return this;
        }

        public ImageToTextBuilder termColorModel(TermColor.TermColorModel termColorModel) {
            this.termColorModel$value = termColorModel;
            this.termColorModel$set = true;
            return this;
        }

        public ImageToTextBuilder transparentColor(int transparentColor) {
            this.transparentColor$value = transparentColor;
            this.transparentColor$set = true;
            return this;
        }

        public ImageToText build() {
            boolean isColorConverted$value = this.isColorConverted$value;
            if (!this.isColorConverted$set) {
                isColorConverted$value = ImageToText.$default$isColorConverted();
            }
            boolean useGrayRamp$value = this.useGrayRamp$value;
            if (!this.useGrayRamp$set) {
                useGrayRamp$value = ImageToText.$default$useGrayRamp();
            }
            int width$value = this.width$value;
            if (!this.width$set) {
                width$value = ImageToText.$default$width();
            }
            double aspectRatio$value = this.aspectRatio$value;
            if (!this.aspectRatio$set) {
                aspectRatio$value = ImageToText.$default$aspectRatio();
            }
            boolean isGraycale$value = this.isGraycale$value;
            if (!this.isGraycale$set) {
                isGraycale$value = ImageToText.$default$isGraycale();
            }
            String customGrayRamp$value = this.customGrayRamp$value;
            if (!this.customGrayRamp$set) {
                customGrayRamp$value = ImageToText.$default$customGrayRamp();
            }
            GrayRampType grayRampType$value = this.grayRampType$value;
            if (!this.grayRampType$set) {
                grayRampType$value = ImageToText.$default$grayRampType();
            }
            TermColor.TermColorModel termColorModel$value = this.termColorModel$value;
            if (!this.termColorModel$set) {
                termColorModel$value = ImageToText.$default$termColorModel();
            }
            int transparentColor$value = this.transparentColor$value;
            if (!this.transparentColor$set) {
                transparentColor$value = ImageToText.$default$transparentColor();
            }
            return new ImageToText(isColorConverted$value, useGrayRamp$value, width$value, aspectRatio$value, isGraycale$value, customGrayRamp$value, grayRampType$value, termColorModel$value, transparentColor$value);
        }

        public String toString() {
            return "ImageToText.ImageToTextBuilder(isColorConverted$value=" + this.isColorConverted$value + ", useGrayRamp$value=" + this.useGrayRamp$value + ", width$value=" + this.width$value + ", aspectRatio$value=" + this.aspectRatio$value + ", isGraycale$value=" + this.isGraycale$value + ", customGrayRamp$value=" + this.customGrayRamp$value + ", grayRampType$value=" + (Object)((Object)this.grayRampType$value) + ", termColorModel$value=" + (Object)((Object)this.termColorModel$value) + ", transparentColor$value=" + this.transparentColor$value + ")";
        }
    }

    public static enum GrayRampType {
        STANDARD("$@B%8&WM#*oahkbdpqwmZO0QLCJUYXzcvunxrjft/|()1{}[]?-_+~<>i!lI;:,\"^`'. "),
        SHORT("@%#*+=-:. "),
        UNICODE_SHADE("\u2588\u2593\u2592\u2591 "),
        IBM_437_SHADE(new String(new char[]{'\u00db', '\u00b2', '\u00b1', '\u00b0', ' '}));

        final String ramp;

        private GrayRampType(String ramp) {
            this.ramp = ramp;
        }

        public String getRamp() {
            return this.ramp;
        }
    }
}

