/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.bannersnatch.color;

import hu.blackbelt.bannersnatch.color.Rgb;
import hu.blackbelt.bannersnatch.color.TermColor;

public class Hsl {
    public final double h;
    public final double s;
    public final double l;

    public Hsl(double hue, double saturation, double lightness) {
        if (hue > 1.0 || hue < 0.0 || saturation > 1.0 || saturation < 0.0 || lightness > 1.0 || lightness < 0.0) {
            throw new IllegalArgumentException("hue, saturation and lightness value have to be between 0.0 and 1.0");
        }
        this.h = hue;
        this.s = saturation;
        this.l = lightness;
    }

    public Hsl(double hue) {
        this(hue, 1.0, 0.5);
    }

    public Rgb toRgb() {
        double r;
        double g;
        double b;
        if (this.s <= 0.0) {
            g = b = this.l;
            r = b;
        } else {
            double q = this.l < 0.5 ? this.l * (1.0 + this.s) : this.l + this.s - this.l * this.s;
            double p = 2.0 * this.l - q;
            r = this.hue2rgb(p, q, this.h + 0.3333333333333333);
            g = this.hue2rgb(p, q, this.h);
            b = this.hue2rgb(p, q, this.h - 0.3333333333333333);
        }
        return new Rgb((int)Math.round(r * 255.0), (int)Math.round(g * 255.0), (int)Math.round(b * 255.0));
    }

    public TermColor toTerminalColor() {
        return this.toRgb().toTerminalColor();
    }

    public Hsl interpolate(Hsl target, double coefficient) {
        if (coefficient > 1.0 || coefficient < 0.0) {
            throw new IllegalArgumentException("Coefficient have to be between 0.0 and 1.0");
        }
        return new Hsl(this.h + (target.h - this.h) * coefficient, this.s + (target.s - this.s) * coefficient, this.l + (target.l - this.l) * coefficient);
    }

    private double hue2rgb(double p, double q, double t) {
        if (t < 0.0) {
            t += 1.0;
        }
        if (t > 1.0) {
            t -= 1.0;
        }
        if (t < 0.16666666666666666) {
            return p + (q - p) * 6.0 * t;
        }
        if (t < 0.5) {
            return q;
        }
        if (t < 0.6666666666666666) {
            return p + (q - p) * (0.6666666666666666 - t) * 6.0;
        }
        return p;
    }
}

