/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.bannersnatch.color;

import hu.blackbelt.bannersnatch.color.Hsl;
import hu.blackbelt.bannersnatch.color.TermColor;

public class Rgb {
    public int r;
    public int g;
    public int b;

    public Rgb(int r, int g, int b) {
        if (r > 255 || r < 0 || g > 255 || g < 0 || b > 255 || b < 0) {
            throw new IllegalArgumentException("r,b,b value have to be between 0 and 255.");
        }
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public Rgb(int val) {
        this.r = val >> 16 & 0xFF;
        this.g = val >> 8 & 0xFF;
        this.b = val & 0xFF;
    }

    int toInt() {
        return (this.r << 16) + (this.g << 8) + this.b;
    }

    public Hsl toHsl() {
        double rr = (double)this.r / 255.0;
        double gg = (double)this.g / 255.0;
        double bb = (double)this.b / 255.0;
        double min = Math.min(rr, Math.min(gg, bb));
        double max = Math.max(rr, Math.max(gg, bb));
        double h = 0.0;
        h = max == min ? 0.0 : (max == rr ? (60.0 * (gg - bb) / (max - min) + 360.0) % 360.0 : (max == gg ? 60.0 * (bb - rr) / (max - min) + 120.0 : 60.0 * (rr - gg) / (max - min) + 240.0));
        double l = (max + min) / 2.0;
        double s = 0.0;
        s = max == min ? 0.0 : (l <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
        return new Hsl(h / 360.0, s, l);
    }

    public TermColor toTerminalColor() {
        return new TermColor(this);
    }

    public Rgb interpolate(Rgb target, double coefficient) {
        return new Rgb((int)((double)this.r + ((double)target.r - (double)this.r) * coefficient), (int)((double)this.g + ((double)target.g - (double)this.g) * coefficient), (int)((double)this.b + ((double)target.b - (double)this.b) * coefficient));
    }

    public Rgb toGrayscale() {
        int gray = (int)(0.21f * (float)this.r + 0.72f * (float)this.g + 0.07f * (float)this.b) & 0xFF;
        return new Rgb(gray, gray, gray);
    }
}

