/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.bannersnatch.color;

import hu.blackbelt.bannersnatch.color.Rgb;

public class TermColor {
    public static String RESET = "\u001b[0m";
    private static final int[] COLOR_256_TO_16 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 4, 4, 4, 12, 12, 2, 6, 4, 4, 12, 12, 2, 2, 6, 4, 12, 12, 2, 2, 2, 6, 12, 12, 10, 10, 10, 10, 14, 12, 10, 10, 10, 10, 10, 14, 1, 5, 4, 4, 12, 12, 3, 8, 4, 4, 12, 12, 2, 2, 6, 4, 12, 12, 2, 2, 2, 6, 12, 12, 10, 10, 10, 10, 14, 12, 10, 10, 10, 10, 10, 14, 1, 1, 5, 4, 12, 12, 1, 1, 5, 4, 12, 12, 3, 3, 8, 4, 12, 12, 2, 2, 2, 6, 12, 12, 10, 10, 10, 10, 14, 12, 10, 10, 10, 10, 10, 14, 1, 1, 1, 5, 12, 12, 1, 1, 1, 5, 12, 12, 1, 1, 1, 5, 12, 12, 3, 3, 3, 7, 12, 12, 10, 10, 10, 10, 14, 12, 10, 10, 10, 10, 10, 14, 9, 9, 9, 9, 13, 12, 9, 9, 9, 9, 13, 12, 9, 9, 9, 9, 13, 12, 9, 9, 9, 9, 13, 12, 11, 11, 11, 11, 7, 12, 10, 10, 10, 10, 10, 14, 9, 9, 9, 9, 9, 13, 9, 9, 9, 9, 9, 13, 9, 9, 9, 9, 9, 13, 9, 9, 9, 9, 9, 13, 9, 9, 9, 9, 9, 13, 11, 11, 11, 11, 11, 15, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 15, 15, 15, 15, 15, 15};
    private static final int[] q2c = new int[]{0, 95, 135, 175, 215, 255};
    private Rgb rgb;
    private Rgb grayscale;

    public TermColor(Rgb rgb) {
        this.rgb = rgb;
        this.grayscale = rgb.toGrayscale();
    }

    private int getColorCode256Color(int r, int g, int b) {
        int qr = this.colourTo6cube(r);
        int cr = q2c[qr];
        int qg = this.colourTo6cube(g);
        int cg = q2c[qg];
        int qb = this.colourTo6cube(b);
        int cb = q2c[qb];
        if (cr == r && cg == g && cb == b) {
            return 16 + 36 * qr + 6 * qg + qb;
        }
        int grey_avg = (r + g + b) / 3;
        int grey_idx = grey_avg > 238 ? 23 : (grey_avg - 3) / 10;
        int grey = 8 + 10 * grey_idx;
        int d = this.colorDistSq(cr, cg, cb, r, g, b);
        int idx = this.colorDistSq(grey, grey, grey, r, g, b) < d ? 232 + grey_idx : 16 + 36 * qr + 6 * qg + qb;
        return idx;
    }

    public int getColorCode256Color() {
        return this.getColorCode256Color(this.rgb.r, this.rgb.g, this.rgb.b);
    }

    public int getColorCode256Grayscale() {
        return this.getColorCode256Color(this.grayscale.r, this.grayscale.g, this.grayscale.b);
    }

    public int getColorCode16Color() {
        return COLOR_256_TO_16[this.getColorCode256Color() & 0xFF];
    }

    public int getColorCode16Grayscale() {
        return COLOR_256_TO_16[this.getColorCode256Grayscale() & 0xFF];
    }

    public int getColorCode(TermColorModel termColorModel, boolean gray) {
        if (TermColorModel.COLOR_RGB == termColorModel) {
            throw new IllegalArgumentException("getColor is not supported in RGB Style");
        }
        if (TermColorModel.COLOR_256 == termColorModel) {
            if (gray) {
                return this.getColorCode256Grayscale();
            }
            return this.getColorCode256Color();
        }
        if (gray) {
            return this.getColorCode16Grayscale();
        }
        return this.getColorCode16Color();
    }

    public String toAnsiSequence(TermColorModel termColorModel, boolean isBackground, boolean isGrayScale) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u001b[");
        Rgb col = this.rgb;
        if (isGrayScale) {
            col = this.grayscale;
        }
        if (termColorModel != TermColorModel.COLOR_16_LEGACY) {
            if (isBackground) {
                sb.append("48;");
            } else {
                sb.append("38;");
            }
            if (termColorModel == TermColorModel.COLOR_RGB) {
                sb.append("2;" + col.r + ";" + col.g + ";" + col.b);
            } else {
                sb.append("5;" + this.getColorCode(termColorModel, isGrayScale));
            }
        } else {
            int color = this.getColorCode(termColorModel, isGrayScale);
            int seq = color < 8 ? color + 30 : color + 82;
            if (isBackground) {
                seq += 10;
            }
            sb.append(seq);
        }
        sb.append('m');
        return sb.toString();
    }

    private int colorDistSq(int cr, int cg, int cb, int r, int g, int b) {
        return (cr - r) * (cr - r) + (cg - g) * (cg - g) + (cb - b) * (cb - b);
    }

    private int colourTo6cube(int v) {
        if (v < 48) {
            return 0;
        }
        if (v < 114) {
            return 1;
        }
        return (v - 35) / 40;
    }

    public static enum TermColorModel {
        COLOR_16,
        COLOR_256,
        COLOR_RGB,
        COLOR_16_LEGACY;

    }
}

