/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.bannersnatch.figlet;

import hu.blackbelt.bannersnatch.figlet.FigFontReader;
import hu.blackbelt.bannersnatch.figlet.LayoutOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class FigFont {
    private char hardBlankChar;
    private int height;
    private int baseline;
    private int maxLength;
    private int oldLayout;
    private int commentLines;
    private PrintDirection printDirection;
    private int fullLayout;
    private int codetagCount;
    private Map<Character, FigCharacter> figCharacters = new HashMap<Character, FigCharacter>();

    public char getHardBlankChar() {
        return this.hardBlankChar;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBaseline() {
        return this.baseline;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getOldLayout() {
        return this.oldLayout;
    }

    public int getCommentLines() {
        return this.commentLines;
    }

    public PrintDirection getPrintDirection() {
        return this.printDirection;
    }

    public int getFullLayout() {
        return this.fullLayout;
    }

    public int getCodetagCount() {
        return this.codetagCount;
    }

    public FigCharacter getFigCharacter(char character) {
        return this.figCharacters.get(Character.valueOf(character));
    }

    public int calculateOverlapAmount(char char1, char char2, int smushMode, PrintDirection printDirection) {
        FigCharacter rightFigChar;
        FigCharacter leftFigChar;
        if (!LayoutOptions.islayoutOptionSelected(192, smushMode)) {
            return 0;
        }
        if (char1 == '\u0000' || char2 == '\u0000') {
            return 0;
        }
        if (printDirection == PrintDirection.LEFT_TO_RIGHT) {
            leftFigChar = this.getFigCharacter(char1);
            rightFigChar = this.getFigCharacter(char2);
        } else {
            leftFigChar = this.getFigCharacter(char2);
            rightFigChar = this.getFigCharacter(char1);
        }
        if (rightFigChar.getWidth() < 2 || leftFigChar.getWidth() < 2) {
            return 0;
        }
        int smushAmount = rightFigChar.getWidth();
        for (int row = 0; row < this.getHeight(); ++row) {
            int rightFigCharLeftBoundary;
            int leftFigCharRightBoundary;
            for (leftFigCharRightBoundary = leftFigChar.getWidth() - 1; leftFigChar.getCharacterAt(leftFigCharRightBoundary, row) == ' ' && leftFigCharRightBoundary > 0; --leftFigCharRightBoundary) {
            }
            for (rightFigCharLeftBoundary = 0; rightFigChar.getCharacterAt(rightFigCharLeftBoundary, row) == ' ' && rightFigCharLeftBoundary < rightFigChar.getWidth() - 1; ++rightFigCharLeftBoundary) {
            }
            int rowSmushAmount = Math.min(rightFigChar.getWidth(), leftFigChar.getWidth() - (leftFigCharRightBoundary + 1) + rightFigCharLeftBoundary);
            if (leftFigChar.getCharacterAt(leftFigCharRightBoundary, row) == ' ') {
                ++rowSmushAmount;
            } else if (this.smushem(leftFigChar.getCharacterAt(leftFigCharRightBoundary, row), rightFigChar.getCharacterAt(rightFigCharLeftBoundary, row), smushMode, printDirection) != '\u0000') {
                ++rowSmushAmount;
            }
            smushAmount = Math.min(smushAmount, rowSmushAmount);
        }
        return smushAmount;
    }

    public char smushem(char char1, char char2, int smushmode, PrintDirection printDirection) {
        if (char1 == ' ') {
            return char2;
        }
        if (char2 == ' ') {
            return char1;
        }
        if (!LayoutOptions.islayoutOptionSelected(128, smushmode)) {
            return '\u0000';
        }
        if ((smushmode & 0x3F) == 0) {
            if (char1 == ' ') {
                return char2;
            }
            if (char2 == ' ') {
                return char1;
            }
            if (char1 == this.hardBlankChar) {
                return char2;
            }
            if (char2 == this.hardBlankChar) {
                return char1;
            }
            if (printDirection == PrintDirection.LEFT_TO_RIGHT) {
                return char2;
            }
            return char1;
        }
        if (LayoutOptions.islayoutOptionSelected(32, smushmode) && char1 == this.hardBlankChar && char2 == this.hardBlankChar) {
            return char1;
        }
        if (char1 == this.hardBlankChar || char2 == this.hardBlankChar) {
            return '\u0000';
        }
        if (LayoutOptions.islayoutOptionSelected(1, smushmode) && char1 == char2) {
            return char1;
        }
        if (LayoutOptions.islayoutOptionSelected(2, smushmode)) {
            if (char1 == '_' && "|/\\[]{}()<>".indexOf(char2) != -1) {
                return char2;
            }
            if (char2 == '_' && "|/\\[]{}()<>".indexOf(char1) != -1) {
                return char1;
            }
        }
        if (LayoutOptions.islayoutOptionSelected(4, smushmode)) {
            if (char1 == '|' && "/\\[]{}()<>".indexOf(char2) != -1) {
                return char2;
            }
            if (char2 == '|' && "/\\[]{}()<>".indexOf(char1) != -1) {
                return char1;
            }
            if ("/\\".indexOf(char1) != -1 && "[]{}()<>".indexOf(char2) != -1) {
                return char2;
            }
            if ("/\\".indexOf(char2) != -1 && "[]{}()<>".indexOf(char1) != -1) {
                return char1;
            }
            if ("[]".indexOf(char1) != -1 && "{}()<>".indexOf(char2) != -1) {
                return char2;
            }
            if ("[]".indexOf(char2) != -1 && "{}()<>".indexOf(char1) != -1) {
                return char1;
            }
            if ("{}".indexOf(char1) != -1 && "()<>".indexOf(char2) != -1) {
                return char2;
            }
            if ("{}".indexOf(char2) != -1 && "()<>".indexOf(char1) != -1) {
                return char1;
            }
            if ("()".indexOf(char1) != -1 && "<>".indexOf(char2) != -1) {
                return char2;
            }
            if ("()".indexOf(char2) != -1 && "<>".indexOf(char1) != -1) {
                return char1;
            }
        }
        if (LayoutOptions.islayoutOptionSelected(8, smushmode)) {
            if (char1 == '[' && char2 == ']') {
                return '|';
            }
            if (char2 == '[' && char1 == ']') {
                return '|';
            }
            if (char1 == '{' && char2 == '}') {
                return '|';
            }
            if (char2 == '{' && char1 == '}') {
                return '|';
            }
            if (char1 == '(' && char2 == ')') {
                return '|';
            }
            if (char2 == '(' && char1 == ')') {
                return '|';
            }
        }
        if (LayoutOptions.islayoutOptionSelected(16, smushmode)) {
            if (char1 == '/' && char2 == '\\') {
                return '|';
            }
            if (char2 == '/' && char1 == '\\') {
                return 'Y';
            }
            if (char1 == '>' && char2 == '<') {
                return 'X';
            }
        }
        return '\u0000';
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Character, FigCharacter> figCharactersEntry : this.figCharacters.entrySet()) {
            stringBuilder.append(figCharactersEntry.getKey());
            stringBuilder.append(":\n");
            stringBuilder.append(figCharactersEntry.getValue());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static FigFont loadFigFont(InputStream inputStream) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
            FigFontReader fontReader = new FigFontReader(inputStreamReader);
            FigFont figFont = fontReader.readFont();
            return figFont;
        }
    }

    public static class FigCharacter {
        private final FigFont font;
        private final String characterData;

        private FigCharacter(FigFont font, String characterData) {
            this.font = font;
            this.characterData = characterData;
        }

        public char getCharacterAt(int column, int row) throws IndexOutOfBoundsException {
            if (column >= 0 && column < this.getWidth() && row >= 0 && row < this.getHeight()) {
                return this.characterData.charAt(row * this.getWidth() + column);
            }
            throw new IndexOutOfBoundsException("Character index out of bounds: " + column + ", " + row);
        }

        public String getRow(int row) throws IndexOutOfBoundsException {
            if (row >= 0 && row < this.getHeight()) {
                int rowStart = row * this.getWidth();
                return this.characterData.substring(rowStart, rowStart + this.getWidth());
            }
            throw new IndexOutOfBoundsException("Character row must be between 0 and " + (this.getHeight() - 1) + ": " + row);
        }

        public int getWidth() {
            return this.characterData.length() / this.font.getHeight();
        }

        public int getHeight() {
            return this.font.getHeight();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int width = this.getWidth();
            for (int y = 0; y < this.font.getHeight(); ++y) {
                stringBuilder.append(this.characterData.substring(width * y, width * y + width));
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
    }

    public static class Builder
    extends FigFont {
        private char hardBlankChar;
        private int height;
        private int baseline;
        private int maxLength;
        private int oldLayout;
        private int commentLines;
        private PrintDirection printDirection = PrintDirection.LEFT_TO_RIGHT;
        private int fullLayout;
        private int codetagCount;
        private Map<Character, String> characterDataMap = new HashMap<Character, String>();

        @Override
        public char getHardBlankChar() {
            return this.hardBlankChar;
        }

        public Builder setHardBlankChar(char hardBlankChar) {
            this.hardBlankChar = hardBlankChar;
            return this;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        @Override
        public int getBaseline() {
            return this.baseline;
        }

        public Builder setBaseline(int baseline) {
            this.baseline = baseline;
            return this;
        }

        @Override
        public int getMaxLength() {
            return this.maxLength;
        }

        public Builder setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        @Override
        public int getOldLayout() {
            return this.oldLayout;
        }

        public Builder setOldLayout(int oldLayout) {
            this.oldLayout = oldLayout;
            return this;
        }

        @Override
        public int getCommentLines() {
            return this.commentLines;
        }

        public Builder setCommentLines(int commentLines) {
            this.commentLines = commentLines;
            return this;
        }

        @Override
        public PrintDirection getPrintDirection() {
            return this.printDirection;
        }

        public Builder setPrintDirection(PrintDirection printDirection) {
            this.printDirection = printDirection;
            return this;
        }

        @Override
        public int getFullLayout() {
            return this.fullLayout;
        }

        public Builder setFullLayout(int fullLayout) {
            this.fullLayout = fullLayout;
            return this;
        }

        @Override
        public int getCodetagCount() {
            return this.codetagCount;
        }

        public Builder setCodetagCount(int codetagCount) {
            this.codetagCount = codetagCount;
            return this;
        }

        public Builder setFigCharacter(char character, String characterData) {
            this.characterDataMap.put(Character.valueOf(character), characterData);
            return this;
        }

        public FigFont build() {
            FigFont font = new FigFont();
            font.hardBlankChar = this.hardBlankChar;
            font.height = this.height;
            font.baseline = this.baseline;
            font.maxLength = this.maxLength;
            font.oldLayout = this.oldLayout;
            font.commentLines = this.commentLines;
            font.printDirection = this.printDirection;
            font.fullLayout = this.fullLayout;
            font.codetagCount = this.codetagCount;
            font.figCharacters = new HashMap(this.characterDataMap.size());
            for (Map.Entry<Character, String> entry : this.characterDataMap.entrySet()) {
                font.figCharacters.put(entry.getKey(), new FigCharacter(font, entry.getValue()));
            }
            return font;
        }
    }

    public static enum PrintDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;


        public static PrintDirection ofHeaderValue(int headerValue) throws IllegalArgumentException {
            PrintDirection printDirection;
            switch (headerValue) {
                case 0: {
                    printDirection = LEFT_TO_RIGHT;
                    break;
                }
                case 1: {
                    printDirection = RIGHT_TO_LEFT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognised header value: " + headerValue);
                }
            }
            return printDirection;
        }
    }
}

