/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.bannersnatch.figlet;

import hu.blackbelt.bannersnatch.figlet.FigFont;
import hu.blackbelt.bannersnatch.figlet.LayoutOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FigFontReader {
    public static final String FONT_MAGIC_NUMBER = "flf2";
    private static final Pattern CODE_TAG_PATTERN = Pattern.compile("([^\\s]+)\\s*.*");
    private static final int[] deutschCodePoints = new int[]{196, 214, 220, 228, 246, 252, 223};
    private final Reader reader;

    public FigFontReader(Reader reader) {
        this.reader = reader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FigFont readFont() throws IOException {
        FigFont.Builder fontBuilder = new FigFont.Builder();
        try (BufferedReader bufferedReader = new BufferedReader(this.reader);){
            String line;
            String header = bufferedReader.readLine();
            try {
                FigFontReader.parseHeader(header, fontBuilder);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Could not read font header", e);
            }
            for (int commentCounter = 0; commentCounter < fontBuilder.getCommentLines(); ++commentCounter) {
                String string = bufferedReader.readLine();
            }
            for (int codePoint = 32; codePoint < 127; ++codePoint) {
                String characterData = FigFontReader.readCharacterData(fontBuilder.getHeight(), bufferedReader);
                fontBuilder.setFigCharacter((char)codePoint, characterData);
            }
            for (int codePoint : deutschCodePoints) {
                String characterData = FigFontReader.readCharacterData(fontBuilder.getHeight(), bufferedReader);
                fontBuilder.setFigCharacter((char)codePoint, characterData);
            }
            while ((line = bufferedReader.readLine()) != null) {
                String characterData = FigFontReader.readCharacterData(fontBuilder.getHeight(), bufferedReader);
                try {
                    fontBuilder.setFigCharacter(FigFontReader.parseCodeTag(line), characterData);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Could not parse code tag", e);
                    return fontBuilder.build();
                }
            }
        }
    }

    public static char parseCodeTag(String codeTagText) throws IllegalArgumentException {
        Matcher codeTagMatcher = CODE_TAG_PATTERN.matcher(codeTagText);
        if (codeTagMatcher.matches()) {
            String codePointText = codeTagMatcher.group(1);
            int codePoint = Integer.decode(codePointText);
            return (char)codePoint;
        }
        throw new IllegalArgumentException("Could not parse text as a code tag: " + codeTagText);
    }

    public static String readCharacterData(int height, BufferedReader bufferedReader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int charLine = 0; charLine < height; ++charLine) {
            int charIndex;
            String line = bufferedReader.readLine();
            if (line != null) {
                for (charIndex = line.length() - 1; charIndex >= 0 && Character.isWhitespace(line.charAt(charIndex)); --charIndex) {
                }
                char endChar = line.charAt(charIndex);
                while (charIndex >= 0 && line.charAt(charIndex) == endChar) {
                    --charIndex;
                }
            } else {
                throw new IllegalStateException("Could not parse");
            }
            stringBuilder.append(line.substring(0, charIndex + 1));
        }
        return stringBuilder.toString();
    }

    public static void parseHeader(String header, FigFont.Builder fontBuilder) throws IllegalArgumentException {
        String[] arguments = header.split("\\s+");
        if (arguments[0].startsWith(FONT_MAGIC_NUMBER)) {
            fontBuilder.setHardBlankChar(arguments[0].charAt(arguments[0].length() - 1));
            if (arguments.length > 1) {
                fontBuilder.setHeight(Integer.decode(arguments[1]));
            }
            if (arguments.length > 2) {
                fontBuilder.setBaseline(Integer.decode(arguments[2]));
            }
            if (arguments.length > 3) {
                fontBuilder.setMaxLength(Integer.decode(arguments[3]));
            }
            if (arguments.length > 4) {
                int oldLayout = Integer.decode(arguments[4]);
                fontBuilder.setOldLayout(oldLayout);
                fontBuilder.setFullLayout(LayoutOptions.fullLayoutFromOldLayout(oldLayout));
            }
            if (arguments.length > 5) {
                fontBuilder.setCommentLines(Integer.decode(arguments[5]));
            }
            if (arguments.length > 6) {
                fontBuilder.setPrintDirection(FigFont.PrintDirection.ofHeaderValue(Integer.decode(arguments[6])));
            }
            if (arguments.length > 7) {
                fontBuilder.setFullLayout(Integer.decode(arguments[7]));
            }
            if (arguments.length > 8) {
                fontBuilder.setCodetagCount(Integer.decode(arguments[8]));
            }
        } else {
            throw new IllegalArgumentException("Header does not start with FIGfont magic number flf2: " + header);
        }
    }
}

