/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.bannersnatch.figlet;

import hu.blackbelt.bannersnatch.figlet.FigFont;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class FigletRenderer {
    private FigFont figFont;
    private int smushMode;
    private FigFont.PrintDirection printDirection;

    public FigletRenderer(FigFont figFont) {
        this.figFont = figFont;
        this.smushMode = figFont.getFullLayout();
        this.printDirection = figFont.getPrintDirection();
    }

    public int getSmushMode() {
        return this.smushMode;
    }

    public void setSmushMode(int smushMode) {
        this.smushMode = smushMode;
    }

    public FigFont.PrintDirection getPrintDirection() {
        return this.printDirection;
    }

    public void setPrintDirection(FigFont.PrintDirection printDirection) {
        this.printDirection = printDirection;
    }

    public String renderText(String text) {
        StringBuilder result = new StringBuilder();
        ArrayList<StringBuilder> rowBuilders = new ArrayList<StringBuilder>(this.figFont.getHeight());
        for (int row = 0; row < this.figFont.getHeight(); ++row) {
            rowBuilders.add(new StringBuilder());
        }
        char prevChar = '\u0000';
        for (char character : text.toCharArray()) {
            if (Character.isWhitespace(character)) {
                char c = character = character == '\t' || character == ' ' ? (char)' ' : '\n';
            }
            if (character > '\u0000' && character < ' ' && character != 10 || character == '\u007f') continue;
            if (character != '\n') {
                int smushAmount = this.figFont.calculateOverlapAmount(prevChar, character, this.smushMode, this.printDirection);
                FigFont.FigCharacter figChar = this.figFont.getFigCharacter(character);
                for (int row = 0; row < this.figFont.getHeight(); ++row) {
                    StringBuilder rowBuilder2 = (StringBuilder)rowBuilders.get(row);
                    if (rowBuilder2.length() > 0) {
                        int smushColumn;
                        if (this.printDirection == FigFont.PrintDirection.LEFT_TO_RIGHT) {
                            for (smushColumn = 0; smushColumn < smushAmount; ++smushColumn) {
                                int smushIndex = rowBuilder2.length() - (smushColumn + 1);
                                rowBuilder2.setCharAt(smushIndex, this.figFont.smushem(rowBuilder2.charAt(smushIndex), figChar.getCharacterAt(smushAmount - (smushColumn + 1), row), this.smushMode, this.printDirection));
                            }
                            rowBuilder2.append(figChar.getRow(row).substring(smushAmount));
                            continue;
                        }
                        for (smushColumn = 0; smushColumn < smushAmount; ++smushColumn) {
                            rowBuilder2.setCharAt(smushColumn, this.figFont.smushem(rowBuilder2.charAt(smushColumn), figChar.getCharacterAt(figChar.getWidth() - smushAmount + smushColumn, row), this.smushMode, this.printDirection));
                        }
                        rowBuilder2.insert(0, figChar.getRow(row).substring(0, figChar.getWidth() - smushAmount));
                        continue;
                    }
                    rowBuilder2.append(figChar.getRow(row));
                }
                prevChar = character;
                continue;
            }
            result.append(rowBuilders.stream().map(rowBuilder -> rowBuilder.toString()).map(s -> s.replace(this.figFont.getHardBlankChar(), ' ')).collect(Collectors.joining("\n", "", "\n")));
            for (int row = 0; row < this.figFont.getHeight(); ++row) {
                ((StringBuilder)rowBuilders.get(row)).setLength(0);
            }
            prevChar = '\u0000';
        }
        result.append(rowBuilders.stream().map(rowBuilder -> rowBuilder.toString()).map(s -> s.replace(this.figFont.getHardBlankChar(), ' ')).collect(Collectors.joining("\n")));
        return result.toString();
    }
}

