/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.flutter.maven.plugin.api;

import hu.blackbelt.flutter.maven.plugin.api.CacheDescriptor;
import hu.blackbelt.flutter.maven.plugin.api.CacheResolver;
import java.io.File;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepositoryManager;

public class RepositoryCacheResolver
implements CacheResolver {
    private static final String GROUP_ID = "hu.blackbelt.flutter.maven/plugin";
    private final RepositorySystemSession repositorySystemSession;

    public RepositoryCacheResolver(RepositorySystemSession repositorySystemSession) {
        this.repositorySystemSession = repositorySystemSession;
    }

    @Override
    public File resolve(CacheDescriptor cacheDescriptor) {
        LocalRepositoryManager manager = this.repositorySystemSession.getLocalRepositoryManager();
        File localArtifact = new File(manager.getRepository().getBasedir(), manager.getPathForLocalArtifact((Artifact)this.createArtifact(cacheDescriptor)));
        return localArtifact;
    }

    private DefaultArtifact createArtifact(CacheDescriptor cacheDescriptor) {
        String version = cacheDescriptor.getVersion();
        DefaultArtifact artifact = new DefaultArtifact(GROUP_ID, cacheDescriptor.getName(), cacheDescriptor.getExtension(), version);
        return artifact;
    }
}

