/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.flutter.maven.plugin.flutter;

import hu.blackbelt.flutter.maven.plugin.api.ArgumentsParser;
import hu.blackbelt.flutter.maven.plugin.api.ProcessExecutionException;
import hu.blackbelt.flutter.maven.plugin.api.ProxyConfig;
import hu.blackbelt.flutter.maven.plugin.api.TaskRunnerException;
import hu.blackbelt.flutter.maven.plugin.api.Utils;
import hu.blackbelt.flutter.maven.plugin.flutter.FlutterExecutor;
import hu.blackbelt.flutter.maven.plugin.flutter.FlutterExecutorConfig;
import hu.blackbelt.flutter.maven.plugin.flutter.FlutterTaskRunner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlutterTaskRunner
implements FlutterTaskRunner {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DS = "//";
    private static final String AT = "@";
    private final String taskName;
    private final String taskLocation;
    private final ArgumentsParser argumentsParser;
    private final FlutterExecutorConfig executorConfig;
    private final Map<String, String> additionalVariables;
    static final String TASK_NAME = "flutter";

    static Map<String, String> buildProxyVariables(ProxyConfig proxyConfig) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        if (!proxyConfig.isEmpty()) {
            ProxyConfig.Proxy proxy = null;
            proxy = proxyConfig.getSecureProxy();
            if (proxy == null) {
                proxy = proxyConfig.getInsecureProxy();
            }
            arguments.put("https-proxy", proxy.getUri().toString());
            arguments.put("http-proxy", proxy.getUri().toString());
            String nonProxyHosts = proxy.getNonProxyHosts();
            if (nonProxyHosts != null && !nonProxyHosts.isEmpty()) {
                String[] nonProxyHostList;
                for (String nonProxyHost : nonProxyHostList = nonProxyHosts.split("\\|")) {
                    arguments.put("noproxy", nonProxyHost.replace("*", ""));
                }
            }
        }
        return arguments;
    }

    public DefaultFlutterTaskRunner(FlutterExecutorConfig config, ProxyConfig proxyConfig) {
        this(config, TASK_NAME, config.getFlutterPath().getAbsolutePath(), Collections.emptyList(), DefaultFlutterTaskRunner.buildProxyVariables(proxyConfig));
    }

    public DefaultFlutterTaskRunner(FlutterExecutorConfig config, String taskLocation) {
        this(config, taskLocation, Collections.emptyList(), Collections.emptyMap());
    }

    public DefaultFlutterTaskRunner(FlutterExecutorConfig config, String taskName, String taskLocation) {
        this(config, taskName, taskLocation, Collections.emptyList(), Collections.emptyMap());
    }

    public DefaultFlutterTaskRunner(FlutterExecutorConfig config, String taskLocation, List<String> additionalArguments, Map<String, String> additionalVariables) {
        this(config, DefaultFlutterTaskRunner.getTaskNameFromLocation(taskLocation), taskLocation, additionalArguments, additionalVariables);
    }

    public DefaultFlutterTaskRunner(FlutterExecutorConfig config, String taskName, String taskLocation, List<String> additionalArguments, Map<String, String> additionalVariables) {
        this.executorConfig = config;
        this.taskName = taskName;
        this.taskLocation = taskLocation;
        this.argumentsParser = new ArgumentsParser(additionalArguments);
        this.additionalVariables = additionalVariables;
    }

    private static String getTaskNameFromLocation(String taskLocation) {
        return taskLocation.replaceAll("^.*/([^/]+)(?:\\.js)?$", "$1");
    }

    @Override
    public final void execute(String args, Map<String, String> environment) throws TaskRunnerException {
        String absoluteTaskLocation = this.getAbsoluteTaskLocation();
        List<String> arguments = this.getArguments(args);
        this.logger.info("Running " + DefaultFlutterTaskRunner.taskToString(this.taskName, arguments) + " in " + this.executorConfig.getWorkingDirectory());
        HashMap<String, String> allEnvironment = new HashMap<String, String>();
        if (this.additionalVariables != null && this.additionalVariables.size() > 0) {
            allEnvironment.putAll(this.additionalVariables);
        }
        if (environment != null && environment.size() > 0) {
            allEnvironment.putAll(environment);
        }
        try {
            int result = new FlutterExecutor(this.executorConfig, arguments, allEnvironment).executeAndRedirectOutput(this.logger);
            if (result != 0) {
                throw new TaskRunnerException(DefaultFlutterTaskRunner.taskToString(this.taskName, arguments) + " failed. (error code " + result + ")");
            }
        }
        catch (ProcessExecutionException e) {
            throw new TaskRunnerException(DefaultFlutterTaskRunner.taskToString(this.taskName, arguments) + " failed.", e);
        }
    }

    private String getAbsoluteTaskLocation() {
        String location = Utils.normalize(this.taskLocation);
        if (Utils.isRelative(this.taskLocation)) {
            File taskFile = new File(this.executorConfig.getWorkingDirectory(), location);
            if (!taskFile.exists()) {
                taskFile = new File(this.executorConfig.getInstallDirectory(), location);
            }
            location = taskFile.getAbsolutePath();
        }
        return location;
    }

    private List<String> getArguments(String args) {
        return this.argumentsParser.parse(args);
    }

    private static String taskToString(String taskName, List<String> arguments) {
        ArrayList<String> clonedArguments = new ArrayList<String>(arguments);
        for (int i = 0; i < clonedArguments.size(); ++i) {
            String s = (String)clonedArguments.get(i);
            boolean maskMavenProxyPassword = s.contains("proxy=");
            if (!maskMavenProxyPassword) continue;
            String bestEffortMaskedPassword = DefaultFlutterTaskRunner.maskPassword(s);
            clonedArguments.set(i, bestEffortMaskedPassword);
        }
        return "'" + taskName + " " + Utils.implode(" ", clonedArguments) + "'";
    }

    private static String maskPassword(String proxyString) {
        String retVal = proxyString;
        if (proxyString != null && !"".equals(proxyString.trim())) {
            boolean hasSchemeDefined = proxyString.contains("http:") || proxyString.contains("https:");
            boolean hasProtocolDefined = proxyString.contains(DS);
            boolean hasAtCharacterDefined = proxyString.contains(AT);
            if (hasSchemeDefined && hasProtocolDefined && hasAtCharacterDefined) {
                String userInfo;
                String[] userParts;
                int lastAtCharIndex;
                boolean hasPossibleURIUserInfo;
                int firstDoubleSlashIndex = proxyString.indexOf(DS);
                boolean bl = hasPossibleURIUserInfo = firstDoubleSlashIndex < (lastAtCharIndex = proxyString.lastIndexOf(AT));
                if (hasPossibleURIUserInfo && (userParts = (userInfo = proxyString.substring(firstDoubleSlashIndex + DS.length(), lastAtCharIndex)).split(":")).length > 0) {
                    int startOfUserNameIndex = firstDoubleSlashIndex + DS.length();
                    int firstColonInUsernameOrEndOfUserNameIndex = startOfUserNameIndex + userParts[0].length();
                    String leftPart = proxyString.substring(0, firstColonInUsernameOrEndOfUserNameIndex);
                    String rightPart = proxyString.substring(lastAtCharIndex);
                    retVal = leftPart + ":***" + rightPart;
                }
            }
        }
        return retVal;
    }
}

