/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.flutter.maven.plugin.flutter;

import hu.blackbelt.flutter.maven.plugin.api.ArchiveExtractionException;
import hu.blackbelt.flutter.maven.plugin.api.ArchiveExtractor;
import hu.blackbelt.flutter.maven.plugin.api.CacheDescriptor;
import hu.blackbelt.flutter.maven.plugin.api.DownloadException;
import hu.blackbelt.flutter.maven.plugin.api.FileDownloader;
import hu.blackbelt.flutter.maven.plugin.api.InstallationException;
import hu.blackbelt.flutter.maven.plugin.api.ProcessExecutionException;
import hu.blackbelt.flutter.maven.plugin.api.ProxyConfig;
import hu.blackbelt.flutter.maven.plugin.flutter.DefaultFlutterExecutorConfig;
import hu.blackbelt.flutter.maven.plugin.flutter.FlutterExecutor;
import hu.blackbelt.flutter.maven.plugin.flutter.InstallConfig;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlutterInstaller {
    public static final Pattern FLUTTER_VERSION_INFO = Pattern.compile("Flutter.(.*).\u2022.channel.(.*).\u2022(.*)");
    private static final Object LOCK = new Object();
    private String flutterVersion;
    private String flutterChannel;
    private String flutterDownloadRoot;
    private String flutterGitUrl;
    private String userName;
    private String password;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;
    private final ProxyConfig proxyConfig;

    FlutterInstaller(InstallConfig config, ProxyConfig proxyConfig, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
        this.proxyConfig = proxyConfig;
    }

    public FlutterInstaller setFlutterVersion(String flutterVersion) {
        this.flutterVersion = flutterVersion;
        return this;
    }

    public FlutterInstaller setFlutterChannel(String flutterChannel) {
        this.flutterChannel = flutterChannel;
        return this;
    }

    public FlutterInstaller setFlutterDownloadRoot(String flutterDownloadRoot) {
        this.flutterDownloadRoot = flutterDownloadRoot;
        return this;
    }

    public FlutterInstaller setFlutterGitUrl(String flutterGitUrl) {
        this.flutterGitUrl = flutterGitUrl;
        return this;
    }

    public FlutterInstaller setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public FlutterInstaller setPassword(String password) {
        this.password = password;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws InstallationException {
        Object object = LOCK;
        synchronized (object) {
            if (this.flutterDownloadRoot == null || this.flutterDownloadRoot.isEmpty()) {
                this.flutterDownloadRoot = this.config.getPlatform().getFlutterDownloadRoot();
            }
            if (this.flutterGitUrl == null || this.flutterGitUrl.isEmpty()) {
                this.flutterGitUrl = this.config.getPlatform().getFlutterGitUrl();
            }
            if (!this.flutterIsAlreadyInstalled()) {
                if (this.flutterVersion != null) {
                    this.logger.info("Installing Flutter version {} from archive", (Object)this.flutterVersion);
                    if (this.config.getPlatform().isWindows()) {
                        this.installFlutterForWindowsFromArchive();
                    } else {
                        this.installFlutterDefaultFromArchive();
                    }
                } else {
                    this.logger.info("Installing Flutter channel {} from git", (Object)this.flutterChannel);
                    this.installFlutterDefaultFromGit();
                }
            }
        }
    }

    private boolean flutterIsAlreadyInstalled() {
        try {
            DefaultFlutterExecutorConfig executorConfig = new DefaultFlutterExecutorConfig(this.config);
            File flutterFile = executorConfig.getFlutterPath();
            try {
                this.setExecutablePermission();
            }
            catch (InstallationException | IOException e) {
                this.logger.error("Could not set permissions");
            }
            if (flutterFile.exists()) {
                String version = new FlutterExecutor(executorConfig, Arrays.asList("--version"), null).executeAndGetResult(this.logger);
                Matcher matcher = FLUTTER_VERSION_INFO.matcher(version);
                if (matcher.find()) {
                    String installedVersion = matcher.group(1);
                    String installedChannel = matcher.group(2);
                    this.logger.info("Flutter {} is already installed on channel: {}. ", (Object)installedVersion, (Object)installedChannel);
                    if (this.flutterVersion != null) {
                        if (this.flutterVersion.equals(installedVersion)) {
                            return true;
                        }
                        this.logger.info("Requested version {} is not matched, switching to: {}", (Object)installedVersion, (Object)this.flutterVersion);
                        return false;
                    }
                    return this.flutterChannel != null && this.flutterChannel.equals(installedChannel);
                }
                this.logger.warn("Could not determinate version");
                return false;
            }
            return false;
        }
        catch (ProcessExecutionException e) {
            this.logger.warn("Could not exec", (Throwable)e);
            return false;
        }
    }

    private void installFlutterForWindowsFromArchive() throws InstallationException {
        try {
            String downloadUrl = this.flutterDownloadRoot + this.config.getPlatform().getFlutterDownloadFilename(this.flutterVersion);
            File tmpDirectory = this.getTempDirectory();
            CacheDescriptor cacheDescriptor = new CacheDescriptor("flutter", this.flutterVersion, this.config.getPlatform().getArchiveExtension());
            File archive = this.config.getCacheResolver().resolve(cacheDescriptor);
            this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password);
            try {
                this.extractFile(archive, tmpDirectory);
            }
            catch (ArchiveExtractionException e) {
                if (e.getCause() instanceof EOFException) {
                    this.logger.error("The archive file {} is corrupted and will be deleted. Please try the build again.", (Object)archive.getPath());
                    archive.delete();
                    FileUtils.deleteDirectory((File)tmpDirectory);
                }
                throw e;
            }
            File flutterBinary = new File(tmpDirectory, "flutter" + File.separator + "bin" + File.separator + "flutter.bat");
            if (!flutterBinary.exists()) {
                throw new FileNotFoundException("Could not find the downloaded Flutter binary in " + flutterBinary);
            }
            File destinationDirectory = this.getInstallDirectory();
            this.deleteInstallDirectory(this.getInstallDirectory());
            File extractedDirectory = new File(tmpDirectory, "flutter");
            this.logger.info("Moving Flutter directory from {} to {}", (Object)extractedDirectory, (Object)destinationDirectory);
            try {
                Files.move(extractedDirectory.toPath(), destinationDirectory.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new InstallationException("Could not install Flutter: Was not allowed to rename " + extractedDirectory + " to " + destinationDirectory);
            }
            this.deleteTempDirectory(tmpDirectory);
            DefaultFlutterExecutorConfig executorConfig = new DefaultFlutterExecutorConfig(this.config);
            new FlutterExecutor(executorConfig, Arrays.asList("doctor"), null).executeAndRedirectOutput(this.logger);
            if (!this.flutterIsAlreadyInstalled()) {
                throw new InstallationException("Could not install Flutter: Was not able to execute version check");
            }
            this.logger.info("Installed flutter locally.");
        }
        catch (IOException e) {
            throw new InstallationException("Could not install Flutter", e);
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download Flutter", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the Flutter archive", e);
        }
        catch (ProcessExecutionException e) {
            throw new InstallationException("Could not execute Flutter doctor", e);
        }
    }

    private void installFlutterDefaultFromArchive() throws InstallationException {
        try {
            String downloadUrl = this.flutterDownloadRoot + this.config.getPlatform().getFlutterDownloadFilename(this.flutterVersion);
            File tmpDirectory = this.getTempDirectory();
            CacheDescriptor cacheDescriptor = new CacheDescriptor("flutter", this.flutterVersion, this.config.getPlatform().getArchiveExtension());
            File archive = this.config.getCacheResolver().resolve(cacheDescriptor);
            this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password);
            try {
                this.extractFile(archive, tmpDirectory);
            }
            catch (ArchiveExtractionException e) {
                if (e.getCause() instanceof EOFException) {
                    this.logger.error("The archive file {} is corrupted and will be deleted. Please try the build again.", (Object)archive.getPath());
                    archive.delete();
                    FileUtils.deleteDirectory((File)tmpDirectory);
                }
                throw e;
            }
            File flutterBinary = new File(tmpDirectory, "flutter" + File.separator + "bin" + File.separator + "flutter");
            if (!flutterBinary.exists()) {
                throw new FileNotFoundException("Could not find the downloaded Flutter binary in " + flutterBinary);
            }
            File destinationDirectory = this.getInstallDirectory();
            this.deleteInstallDirectory(this.getInstallDirectory());
            File extractedDirectory = new File(tmpDirectory, "flutter");
            this.logger.info("Moving Flutter directory from {} to {}", (Object)extractedDirectory, (Object)destinationDirectory);
            try {
                Files.move(extractedDirectory.toPath(), destinationDirectory.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new InstallationException("Could not install Flutter: Was not allowed to rename " + extractedDirectory + " to " + destinationDirectory);
            }
            this.setExecutablePermission();
            this.deleteTempDirectory(tmpDirectory);
            DefaultFlutterExecutorConfig executorConfig = new DefaultFlutterExecutorConfig(this.config);
            new FlutterExecutor(executorConfig, Arrays.asList("doctor"), null).executeAndRedirectOutput(this.logger);
            if (!this.flutterIsAlreadyInstalled()) {
                throw new InstallationException("Could not install Flutter: Was not able to execute version check");
            }
            this.logger.info("Installed Flutter locally.");
        }
        catch (IOException e) {
            throw new InstallationException("Could not install Flutter", e);
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download Flutter", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the Flutter archive", e);
        }
        catch (ProcessExecutionException e) {
            throw new InstallationException("Could not execute Flutter doctor", e);
        }
    }

    private void setExecutablePermission() throws InstallationException, IOException {
        File destinationDirectory = this.getInstallDirectory();
        this.addExecPermission(new File(destinationDirectory, "bin" + File.separator + "flutter"));
        this.addExecPermission(new File(destinationDirectory, "bin" + File.separator + "dart"));
        this.addExecPermission(new File(destinationDirectory, "bin" + File.separator + "internal" + File.separator + "shared.sh"));
        this.addExecPermission(new File(destinationDirectory, "bin" + File.separator + "internal" + File.separator + "update_dart_sdk.sh"));
        this.addExecPermission(new File(destinationDirectory, "bin" + File.separator + "cache" + File.separator + "dart-sdk" + File.separator + "bin"));
    }

    private void installFlutterDefaultFromGit() throws InstallationException {
        try {
            this.setupGitProxy();
            File destinationDirectory = this.getInstallDirectory();
            File gitDir = new File(destinationDirectory, ".git");
            if (gitDir.exists()) {
                this.logger.info("Using existing Flutter git. Set remote to: " + this.flutterGitUrl);
                Git git = Git.open((File)destinationDirectory);
                if (!git.status().call().isClean()) {
                    this.logger.info("Stashing dirty state");
                    git.stashCreate().call();
                }
            } else {
                this.logger.info("Cloning Flutter from git");
                Git git = Git.cloneRepository().setURI(this.flutterGitUrl).setDirectory(destinationDirectory).call();
            }
            DefaultFlutterExecutorConfig executorConfig = new DefaultFlutterExecutorConfig(this.config);
            this.logger.info("Set Flutter to channel:" + this.flutterChannel);
            new FlutterExecutor(executorConfig, Arrays.asList("channel", this.flutterChannel), null).executeAndRedirectOutput(this.logger);
            this.logger.info("Flutter upgrade");
            new FlutterExecutor(executorConfig, Arrays.asList("upgrade"), null).executeAndRedirectOutput(this.logger);
            if (!this.flutterIsAlreadyInstalled()) {
                throw new InstallationException("Could not install Flutter: Was not able to execute version check");
            }
        }
        catch (InvalidRemoteException e) {
            throw new InstallationException("Could not install Flutter", e);
        }
        catch (TransportException e) {
            throw new InstallationException("Could not install Flutter", e);
        }
        catch (GitAPIException e) {
            throw new InstallationException("Could not install Flutter", e);
        }
        catch (IOException e) {
            throw new InstallationException("Could not install Flutter", e);
        }
        catch (ProcessExecutionException e) {
            throw new InstallationException("Could not execute Flutter", e);
        }
    }

    private void setExecutable(File destinationBinary) throws InstallationException {
        if (!destinationBinary.exists()) {
            return;
        }
        if (!destinationBinary.setExecutable(true, false)) {
            throw new InstallationException("Could not install Flutter: Was not allowed to make " + destinationBinary + " executable.");
        }
    }

    private File getTempDirectory() {
        File tmpDirectory = this.config.getTempDirectory();
        if (!tmpDirectory.exists()) {
            this.logger.debug("Creating temporary directory {}", (Object)tmpDirectory);
            tmpDirectory.mkdirs();
        }
        return tmpDirectory;
    }

    private File getInstallDirectory() {
        File installDirectory = this.config.getInstallDirectory();
        return installDirectory;
    }

    private void deleteTempDirectory(File tmpDirectory) throws IOException {
        if (tmpDirectory != null && tmpDirectory.exists()) {
            this.logger.debug("Deleting temporary directory {}", (Object)tmpDirectory);
            FileUtils.deleteDirectory((File)tmpDirectory);
        }
    }

    private void deleteInstallDirectory(File installDirectory) throws IOException {
        if (installDirectory != null && installDirectory.exists()) {
            this.logger.debug("Deleting install directory {}", (Object)installDirectory);
            FileUtils.deleteDirectory((File)installDirectory);
        }
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
        this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
    }

    private void downloadFileIfMissing(String downloadUrl, File destination, String userName, String password) throws DownloadException {
        if (!destination.exists()) {
            this.downloadFile(downloadUrl, destination, userName, password);
        }
    }

    private void downloadFile(String downloadUrl, File destination, String userName, String password) throws DownloadException {
        this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
        this.fileDownloader.download(downloadUrl, destination.getPath(), userName, password);
    }

    private void setupGitProxy() {
        ProxySelector.setDefault(new ProxySelector(){
            final ProxySelector delegate = ProxySelector.getDefault();

            @Override
            public List<Proxy> select(URI uri) {
                if (uri.toString().equals(FlutterInstaller.this.flutterGitUrl)) {
                    ProxyConfig.Proxy proxy = FlutterInstaller.this.proxyConfig.getProxyForUrl(uri.toString());
                    return Arrays.asList(new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(proxy.host, proxy.port)));
                }
                return this.delegate == null ? Arrays.asList(Proxy.NO_PROXY) : this.delegate.select(uri);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                if (uri == null || sa == null || ioe == null) {
                    throw new IllegalArgumentException("Arguments can't be null.");
                }
            }
        });
    }

    private void addExecPermission(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            Files.walk(file.toPath(), new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)).forEach(f -> {
                try {
                    this.addExecPermission(f.toFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        Path path2 = file.toPath();
        Set<String> fileAttributeView = FileSystems.getDefault().supportedFileAttributeViews();
        if (fileAttributeView.contains("posix")) {
            Set<PosixFilePermission> permissions;
            try {
                permissions = Files.getPosixFilePermissions(path2, new LinkOption[0]);
            }
            catch (UnsupportedOperationException e) {
                this.logger.debug("Exec file permission is not set", (Throwable)e);
                return;
            }
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path2, permissions);
        } else if (fileAttributeView.contains("acl")) {
            String username = System.getProperty("user.name");
            UserPrincipal userPrincipal = FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(username);
            AclEntry aclEntry = AclEntry.newBuilder().setPermissions(AclEntryPermission.EXECUTE).setType(AclEntryType.ALLOW).setPrincipal(userPrincipal).build();
            AclFileAttributeView acl = Files.getFileAttributeView(path2, AclFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            List<AclEntry> aclEntries = acl.getAcl();
            aclEntries.add(aclEntry);
            acl.setAcl(aclEntries);
        }
    }
}

