/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.flutter.maven.plugin.flutter;

import hu.blackbelt.flutter.maven.plugin.api.CacheResolver;
import hu.blackbelt.flutter.maven.plugin.api.DefaultArchiveExtractor;
import hu.blackbelt.flutter.maven.plugin.api.DefaultFileDownloader;
import hu.blackbelt.flutter.maven.plugin.api.DirectoryCacheResolver;
import hu.blackbelt.flutter.maven.plugin.api.ProxyConfig;
import hu.blackbelt.flutter.maven.plugin.flutter.DefaultFlutterExecutorConfig;
import hu.blackbelt.flutter.maven.plugin.flutter.DefaultFlutterTaskRunner;
import hu.blackbelt.flutter.maven.plugin.flutter.DefaultInstallConfig;
import hu.blackbelt.flutter.maven.plugin.flutter.FlutterExecutorConfig;
import hu.blackbelt.flutter.maven.plugin.flutter.FlutterInstaller;
import hu.blackbelt.flutter.maven.plugin.flutter.FlutterTaskRunner;
import hu.blackbelt.flutter.maven.plugin.flutter.InstallConfig;
import hu.blackbelt.flutter.maven.plugin.flutter.Platform;
import java.io.File;

public final class FlutterPluginFactory {
    private static final Platform defaultPlatform = Platform.guess();
    private static final String DEFAULT_CACHE_PATH = "cache";
    private final File workingDirectory;
    private final File installDirectory;
    private final File tempDirectory;
    private final CacheResolver cacheResolver;

    public FlutterPluginFactory(File workingDirectory, File installDirectory, File tempDirectory) {
        this(workingDirectory, installDirectory, tempDirectory, FlutterPluginFactory.getDefaultCacheResolver(installDirectory));
    }

    public FlutterPluginFactory(File workingDirectory, File installDirectory, File tempDirectory, CacheResolver cacheResolver) {
        this.workingDirectory = workingDirectory;
        this.installDirectory = installDirectory;
        this.tempDirectory = tempDirectory;
        this.cacheResolver = cacheResolver;
    }

    public FlutterInstaller getFlutterInstaller(ProxyConfig proxy) {
        return new FlutterInstaller(this.getInstallConfig(), proxy, new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public FlutterTaskRunner getFlutterExecutor(ProxyConfig proxy) {
        return new DefaultFlutterTaskRunner(this.getExecutorConfig(), proxy);
    }

    private FlutterExecutorConfig getExecutorConfig() {
        return new DefaultFlutterExecutorConfig(this.getInstallConfig());
    }

    private InstallConfig getInstallConfig() {
        return new DefaultInstallConfig(this.installDirectory, this.tempDirectory, this.workingDirectory, this.cacheResolver, defaultPlatform);
    }

    private static final CacheResolver getDefaultCacheResolver(File root) {
        return new DirectoryCacheResolver(new File(root, DEFAULT_CACHE_PATH));
    }
}

