/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.flutter.maven.plugin.flutter;

import hu.blackbelt.flutter.maven.plugin.flutter.Architecture;
import hu.blackbelt.flutter.maven.plugin.flutter.Channel;
import hu.blackbelt.flutter.maven.plugin.flutter.OS;

class Platform {
    private final String flutterDownloadRoot;
    private final String flutterGitUrl;
    private final OS os;
    private final Architecture architecture;
    private final String classifier;
    private final Channel channel;

    public Platform(OS os, Architecture architecture) {
        this("https://storage.googleapis.com/flutter_infra/releases/", "https://github.com/flutter/flutter.git", os, architecture, Channel.stable, null);
    }

    public Platform(String flutterDownloadRoot, String flutterGitUrl, OS os, Architecture architecture, Channel channel, String classifier) {
        this.channel = channel;
        this.flutterDownloadRoot = flutterDownloadRoot;
        this.flutterGitUrl = flutterGitUrl;
        this.os = os;
        this.architecture = architecture;
        this.classifier = classifier;
    }

    public static Platform guess() {
        OS os = OS.guess();
        Architecture architecture = Architecture.guess();
        return new Platform(os, architecture);
    }

    public String getFlutterDownloadRoot() {
        return this.flutterDownloadRoot;
    }

    public String getFlutterGitUrl() {
        return this.flutterGitUrl;
    }

    public String getArchiveExtension() {
        return this.os.getArchiveExtension();
    }

    public String getCodename() {
        return this.os.getCodename();
    }

    public boolean isWindows() {
        return this.os == OS.Windows;
    }

    public boolean isMac() {
        return this.os == OS.Mac;
    }

    public boolean isLinux() {
        return this.os == OS.Linux;
    }

    public boolean isSunOS() {
        return this.os == OS.SunOS;
    }

    public String getLongFlutterFilename(String flutterVersion) {
        return "flutter_" + this.os.getCodename() + "_" + flutterVersion + "-" + this.channel.name();
    }

    public String getFlutterDownloadFilename(String flutterVersion) {
        return this.channel.name() + "/" + this.os.getCodename() + "/" + this.getLongFlutterFilename(flutterVersion) + "." + this.os.getArchiveExtension();
    }
}

