/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.flutter.maven.plugin.flutter;

import hu.blackbelt.flutter.maven.plugin.api.ProcessExecutionException;
import hu.blackbelt.flutter.maven.plugin.flutter.Platform;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.slf4j.Logger;

final class ProcessExecutor {
    private static final String PATH_ENV_VAR = "PATH";
    private final Map<String, String> environment;
    private CommandLine commandLine;
    private final Executor executor;

    public ProcessExecutor(File workingDirectory, List<String> paths, List<String> command, Platform platform, Map<String, String> additionalEnvironment) {
        this(workingDirectory, paths, command, platform, additionalEnvironment, 0L);
    }

    public ProcessExecutor(File workingDirectory, List<String> paths, List<String> command, Platform platform, Map<String, String> additionalEnvironment, long timeoutInSeconds) {
        this.environment = this.createEnvironment(paths, platform, additionalEnvironment);
        this.commandLine = this.createCommandLine(command);
        this.executor = this.createExecutor(workingDirectory, timeoutInSeconds);
    }

    public String executeAndGetResult(Logger logger) throws ProcessExecutionException {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        int exitValue = this.execute(logger, stdout, stderr);
        if (exitValue == 0) {
            try {
                return stdout.toString("UTF-8").trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new ProcessExecutionException(stdout + " " + e.toString());
            }
        }
        throw new ProcessExecutionException(stdout + " " + stderr);
    }

    public int executeAndRedirectOutput(Logger logger) throws ProcessExecutionException {
        LoggerOutputStream stdout = new LoggerOutputStream(logger, 0);
        return this.execute(logger, (OutputStream)((Object)stdout), (OutputStream)((Object)stdout));
    }

    private int execute(Logger logger, OutputStream stdout, OutputStream stderr) throws ProcessExecutionException {
        logger.debug("Executing command line {}", (Object)this.commandLine);
        try {
            PumpStreamHandler streamHandler = new PumpStreamHandler(stdout, stderr, System.in);
            this.executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
            int exitValue = this.executor.execute(this.commandLine, this.environment);
            logger.debug("Exit value {}", (Object)exitValue);
            return exitValue;
        }
        catch (ExecuteException e) {
            if (this.executor.getWatchdog() != null && this.executor.getWatchdog().killedProcess()) {
                throw new ProcessExecutionException("Process killed after timeout");
            }
            throw new ProcessExecutionException(e);
        }
        catch (IOException e) {
            throw new ProcessExecutionException(e);
        }
    }

    private CommandLine createCommandLine(List<String> command) {
        this.commandLine = new CommandLine(command.get(0));
        for (int i = 1; i < command.size(); ++i) {
            String argument = command.get(i);
            this.commandLine.addArgument(argument, false);
        }
        return this.commandLine;
    }

    private Map<String, String> createEnvironment(List<String> paths, Platform platform, Map<String, String> additionalEnvironment) {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        if (additionalEnvironment != null) {
            environment.putAll(additionalEnvironment);
        }
        if (platform.isWindows()) {
            for (Map.Entry entry : environment.entrySet()) {
                String pathName = (String)entry.getKey();
                if (!PATH_ENV_VAR.equalsIgnoreCase(pathName)) continue;
                String pathValue = (String)entry.getValue();
                environment.put(pathName, this.extendPathVariable(pathValue, paths));
            }
        } else {
            String pathValue = (String)environment.get(PATH_ENV_VAR);
            environment.put(PATH_ENV_VAR, this.extendPathVariable(pathValue, paths));
        }
        return environment;
    }

    private String extendPathVariable(String existingValue, List<String> paths) {
        StringBuilder pathBuilder = new StringBuilder();
        for (String path : paths) {
            pathBuilder.append(path).append(File.pathSeparator);
        }
        if (existingValue != null) {
            pathBuilder.append(existingValue).append(File.pathSeparator);
        }
        return pathBuilder.toString();
    }

    private Executor createExecutor(File workingDirectory, long timeoutInSeconds) {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(workingDirectory);
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        if (timeoutInSeconds > 0L) {
            executor.setWatchdog(new ExecuteWatchdog(timeoutInSeconds * 1000L));
        }
        return executor;
    }

    private static class LoggerOutputStream
    extends LogOutputStream {
        private final Logger logger;

        LoggerOutputStream(Logger logger, int logLevel) {
            super(logLevel);
            this.logger = logger;
        }

        public final void flush() {
        }

        protected void processLine(String line, int logLevel) {
            this.logger.info(line);
        }
    }
}

