/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.flutter.maven.plugin.mojos.flutter;

import hu.blackbelt.flutter.maven.plugin.api.FlutterException;
import hu.blackbelt.flutter.maven.plugin.api.MojoUtils;
import hu.blackbelt.flutter.maven.plugin.api.RepositoryCacheResolver;
import hu.blackbelt.flutter.maven.plugin.api.TaskRunnerException;
import hu.blackbelt.flutter.maven.plugin.flutter.FlutterPluginFactory;
import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;

public abstract class AbstractFlutterMojo
extends AbstractMojo {
    @Component
    protected MojoExecution execution;
    @Parameter(property="skipTests", required=false, defaultValue="false")
    protected Boolean skipTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    protected boolean testFailureIgnore;
    @Parameter(defaultValue="${basedir}", property="flutter-working-directory", required=false)
    protected File workingDirectory;
    @Parameter(defaultValue="${basedir}/.flutter", property="flutter-install-directory", required=false)
    protected File installDirectory;
    @Parameter(property="flutter-temp-directory", defaultValue="${basedir}/target/temp", required=false)
    protected File tempDirectory;
    @Parameter
    protected Map<String, String> environmentVariables;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;

    private boolean skipTestPhase() {
        return this.skipTests != false && this.isTestingPhase();
    }

    private boolean isTestingPhase() {
        String phase = this.execution.getLifecyclePhase();
        return "test".equals(phase) || "integration-test".equals(phase);
    }

    protected abstract void execute(FlutterPluginFactory var1) throws FlutterException;

    protected abstract boolean skipExecution();

    public void execute() throws MojoFailureException {
        if (this.testFailureIgnore && !this.isTestingPhase()) {
            this.getLog().info((CharSequence)"testFailureIgnore property is ignored in non test phases");
        }
        if (!this.skipTestPhase() && !this.skipExecution()) {
            if (this.installDirectory == null) {
                this.installDirectory = this.workingDirectory;
            }
            try {
                this.execute(new FlutterPluginFactory(this.workingDirectory, this.installDirectory, this.tempDirectory, new RepositoryCacheResolver(this.repositorySystemSession)));
            }
            catch (TaskRunnerException e) {
                if (this.testFailureIgnore && this.isTestingPhase()) {
                    this.getLog().error((CharSequence)("There are test failures.\nFailed to run task: " + e.getMessage()), (Throwable)e);
                }
                throw new MojoFailureException("Failed to run task", (Throwable)e);
            }
            catch (FlutterException e) {
                throw MojoUtils.toMojoFailureException(e);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping execution.");
        }
    }
}

