/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.flutter.maven.plugin.mojos.flutter;

import hu.blackbelt.flutter.maven.plugin.api.MojoUtils;
import hu.blackbelt.flutter.maven.plugin.api.ProxyConfig;
import hu.blackbelt.flutter.maven.plugin.api.TaskRunnerException;
import hu.blackbelt.flutter.maven.plugin.flutter.FlutterPluginFactory;
import hu.blackbelt.flutter.maven.plugin.mojos.flutter.AbstractFlutterMojo;
import java.io.File;
import java.util.Collections;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="flutter", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class FlutterMojo
extends AbstractFlutterMojo {
    @Parameter(defaultValue="pub get", property="flutter.arguments", required=false)
    private String arguments;
    @Parameter(property="flutter.flutterInheritsProxyConfigFromMaven", required=false, defaultValue="true")
    private boolean flutterInheritsProxyConfigFromMaven;
    @Parameter(property="serverId", defaultValue="")
    private String serverId;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildContext buildContext;
    @Parameter(property="flutter-skip", defaultValue="${flutter-skip}")
    private boolean skip;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    private ProxyConfig getProxyConfig() {
        if (this.flutterInheritsProxyConfigFromMaven) {
            return MojoUtils.getProxyConfig(this.session, this.decrypter);
        }
        this.getLog().info((CharSequence)"flutter not inheriting proxy config from Maven");
        return new ProxyConfig(Collections.emptyList());
    }

    @Override
    public void execute(FlutterPluginFactory factory) throws TaskRunnerException {
        File pubspec = new File(this.workingDirectory, "pubspec.yaml");
        if (this.buildContext == null || this.buildContext.hasDelta(pubspec) || !this.buildContext.isIncremental()) {
            ProxyConfig proxyConfig = this.getProxyConfig();
            factory.getFlutterExecutor(proxyConfig).execute(this.arguments, this.environmentVariables);
        } else {
            this.getLog().info((CharSequence)"Skipping flutter pub get as pubspec.yaml unchanged");
        }
    }
}

