/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.flutter.maven.plugin.mojos.flutter;

import hu.blackbelt.flutter.maven.plugin.api.InstallationException;
import hu.blackbelt.flutter.maven.plugin.api.MojoUtils;
import hu.blackbelt.flutter.maven.plugin.api.ProxyConfig;
import hu.blackbelt.flutter.maven.plugin.flutter.FlutterPluginFactory;
import hu.blackbelt.flutter.maven.plugin.mojos.flutter.AbstractFlutterMojo;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="install-flutter", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class InstallFlutterMojo
extends AbstractFlutterMojo {
    @Parameter(property="flutter-download-root", required=false, defaultValue="https://storage.googleapis.com/flutter_infra_release/releases/")
    private String flutterDownloadRoot;
    @Parameter(property="flutter-git-url", required=false, defaultValue="https://github.com/flutter/flutter.git")
    private String flutterGitUrl;
    @Parameter(property="flutter-version", required=false)
    private String flutterVersion;
    @Parameter(property="flutter-channel", defaultValue="stable", required=false)
    private String flutterChannel;
    @Parameter(property="serverId", defaultValue="")
    private String serverId;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="flutter-install-skip", defaultValue="${flutter-install-skip}")
    private boolean skip;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public void execute(FlutterPluginFactory factory) throws InstallationException {
        ProxyConfig proxyConfig = MojoUtils.getProxyConfig(this.session, this.decrypter);
        String flutterDownloadRoot = this.getFlutterDownloadRoot();
        String flutterGitUrl = this.getFlutterGitUrl();
        Server server = MojoUtils.decryptServer(this.serverId, this.session, this.decrypter);
        if (null != server) {
            factory.getFlutterInstaller(proxyConfig).setFlutterVersion(this.flutterVersion).setFlutterChannel(this.flutterChannel).setFlutterDownloadRoot(flutterDownloadRoot).setFlutterGitUrl(flutterGitUrl).setUserName(server.getUsername()).setPassword(server.getPassword()).install();
        } else {
            factory.getFlutterInstaller(proxyConfig).setFlutterVersion(this.flutterVersion).setFlutterChannel(this.flutterChannel).setFlutterDownloadRoot(flutterDownloadRoot).setFlutterGitUrl(flutterGitUrl).install();
        }
    }

    private String getFlutterDownloadRoot() {
        return this.flutterDownloadRoot;
    }

    private String getFlutterGitUrl() {
        return this.flutterGitUrl;
    }
}

