/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import jakarta.enterprise.inject.Typed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.api.message.MessageInterpolator;
import org.apache.deltaspike.core.api.message.MessageResolver;

@Typed
public class DefaultMessage
implements Message {
    private String messageTemplate;
    private List<Serializable> arguments = new ArrayList<Serializable>();
    private MessageContext messageContext;

    public DefaultMessage(MessageContext messageContext) {
        this.reset();
        this.messageContext = messageContext;
    }

    protected void reset() {
        this.messageTemplate = null;
        this.arguments = new ArrayList<Serializable>();
    }

    @Override
    public Message argument(Serializable ... arguments) {
        if (arguments != null) {
            Collections.addAll(this.arguments, arguments);
        }
        return this;
    }

    @Override
    public Message template(String messageTemplate) {
        this.messageTemplate = messageTemplate;
        return this;
    }

    @Override
    public String getTemplate() {
        return this.messageTemplate;
    }

    public Serializable[] getArguments() {
        return this.arguments.toArray(new Serializable[this.arguments.size()]);
    }

    @Override
    public String toString() {
        return this.toString((String)null);
    }

    @Override
    public String toString(String category) {
        MessageInterpolator messageInterpolator;
        String template = this.getTemplate();
        if (template == null) {
            return "";
        }
        String ret = template;
        MessageResolver messageResolver = this.messageContext.getMessageResolver();
        if (messageResolver != null) {
            String resolvedTemplate = messageResolver.getMessage(this.messageContext, template, category);
            if (resolvedTemplate == null) {
                resolvedTemplate = this.markAsUnresolved(template);
            }
            ret = resolvedTemplate;
            template = resolvedTemplate;
        }
        if ((messageInterpolator = this.messageContext.getMessageInterpolator()) != null) {
            Locale locale = this.messageContext.getLocale();
            ret = messageInterpolator.interpolate(template, this.getArguments(), locale);
        }
        return ret;
    }

    private String markAsUnresolved(String template) {
        if (this.messageTemplate.startsWith("{") && this.messageTemplate.endsWith("}")) {
            template = this.messageTemplate.substring(1, this.messageTemplate.length() - 1);
        }
        StringBuilder sb = new StringBuilder("???" + template + "???");
        if (this.getArguments() != null && this.getArguments().length > 0) {
            sb.append(" ").append(Arrays.toString(this.getArguments()));
        }
        return sb.toString();
    }

    @Override
    public String toString(MessageContext messageContext) {
        return this.toString(messageContext, null);
    }

    @Override
    public String toString(MessageContext messageContext, String category) {
        return messageContext.message().template(this.getTemplate()).argument(this.getArguments()).toString(category);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (this.getTemplate() == null && other.getTemplate() != null) {
            return false;
        }
        if (this.getTemplate() != null && !this.getTemplate().equals(other.getTemplate())) {
            return false;
        }
        return !(this.arguments != null ? !Arrays.equals(this.arguments.toArray(), other.getArguments()) : other.getArguments() != null);
    }

    public int hashCode() {
        int result = this.getTemplate().hashCode();
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    @Override
    public Message argumentArray(Serializable[] arguments) {
        if (arguments != null) {
            return this.argument(Arrays.asList(arguments));
        }
        return this;
    }

    @Override
    public Message argument(Collection<Serializable> arguments) {
        if (arguments != null) {
            this.arguments.addAll(arguments);
        }
        return this;
    }
}

