/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.deltaspike.core.api.message.LocaleResolver;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.api.message.MessageInterpolator;
import org.apache.deltaspike.core.api.message.MessageResolver;
import org.apache.deltaspike.core.impl.message.DefaultMessage;

@Dependent
@Typed(value={MessageContext.class})
class DefaultMessageContext
implements MessageContext {
    private static final long serialVersionUID = -110779217295211303L;
    @Inject
    private MessageInterpolator messageInterpolator = null;
    @Inject
    private MessageResolver messageResolver = null;
    @Inject
    private LocaleResolver localeResolver = null;
    private List<String> messageSources = new ArrayList<String>();

    DefaultMessageContext() {
    }

    DefaultMessageContext(MessageContext otherMessageContext) {
        this.messageInterpolator(otherMessageContext.getMessageInterpolator());
        this.localeResolver(otherMessageContext.getLocaleResolver());
        this.messageResolver(otherMessageContext.getMessageResolver());
        this.messageSources.addAll(otherMessageContext.getMessageSources());
    }

    @Override
    public MessageContext clone() {
        return new DefaultMessageContext(this);
    }

    @Override
    public Message message() {
        return new DefaultMessage(this);
    }

    @Override
    public MessageContext messageSource(String ... messageSource) {
        ArrayList<String> newMessageSources = new ArrayList<String>();
        for (String currentMessageSource : messageSource) {
            if (this.messageSources.contains(currentMessageSource)) continue;
            newMessageSources.add(currentMessageSource);
        }
        this.messageSources.addAll(0, newMessageSources);
        return this;
    }

    @Override
    public Locale getLocale() {
        if (this.getLocaleResolver() == null) {
            return Locale.getDefault();
        }
        return this.getLocaleResolver().getLocale();
    }

    @Override
    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    @Override
    public List<String> getMessageSources() {
        return Collections.unmodifiableList(this.messageSources);
    }

    @Override
    public MessageContext localeResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
        return this;
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    @Override
    public MessageContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
        return this;
    }

    @Override
    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    @Override
    public MessageContext messageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
        return this;
    }
}

