/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.dto.adapter;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class LocalDateXmlAdapter
extends XmlAdapter<String, LocalDate> {
    public LocalDate unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        try {
            Long timeInMillis = Long.parseLong(v);
            Instant instant = Instant.ofEpochMilli(timeInMillis);
            return LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalDate();
        }
        catch (NumberFormatException e) {
            return LocalDate.parse(v, DateTimeFormatter.ISO_DATE);
        }
    }

    public String marshal(LocalDate localDate) throws Exception {
        if (localDate == null) {
            return null;
        }
        return DateTimeFormatter.ISO_DATE.format(localDate);
    }
}

