/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.dto.adapter;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class OffsetDateTimeXmlAdapter
extends XmlAdapter<String, OffsetDateTime> {
    public OffsetDateTime unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        try {
            Long timeInMillis = Long.parseLong(v);
            return this.parseLong(timeInMillis);
        }
        catch (NumberFormatException e) {
            return this.parseString(v);
        }
    }

    private OffsetDateTime parseString(String from) {
        try {
            return OffsetDateTime.parse(from, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        catch (DateTimeParseException ex) {
            LocalDateTime localDateTime = LocalDateTime.parse(from, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            return OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
        }
    }

    private OffsetDateTime parseLong(Long timeInMillis) {
        Instant instant = Instant.ofEpochMilli(timeInMillis);
        return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    public String marshal(OffsetDateTime offsetDateTime) throws Exception {
        if (offsetDateTime == null) {
            return null;
        }
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(offsetDateTime);
    }
}

