/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.dto.adapter;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class OffsetTimeXmlAdapter
extends XmlAdapter<String, OffsetTime> {
    public OffsetTime unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        return this.parseString(v);
    }

    private OffsetTime parseString(String from) {
        try {
            return OffsetTime.parse(from, DateTimeFormatter.ISO_OFFSET_TIME);
        }
        catch (DateTimeParseException ex) {
            LocalTime localTime = LocalTime.parse(from, DateTimeFormatter.ISO_LOCAL_TIME);
            return OffsetTime.of(localTime, ZoneOffset.UTC);
        }
    }

    public String marshal(OffsetTime offsetTime) throws Exception {
        if (offsetTime == null) {
            return null;
        }
        return DateTimeFormatter.ISO_OFFSET_TIME.format(offsetTime);
    }
}

