/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.dto.url;

import hu.icellmobilsoft.coffee.se.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BaseServicePath {
    private static Logger log = Logger.getLogger(BaseServicePath.class);
    private static final String EMPTY = "";
    private static final String SIGN_QUESTION = "?";
    private static final String SIGN_EQUALS = "=";
    private static final String SIGN_AND = "&";
    public static final String PARAM_ID = "id";
    public static final String PARAM_USER_ID = "userId";
    public static final String PARAM_DATE = "date";
    public static final String DATE = "/{date}";
    public static final String ID = "/{id}";
    public static final String USER_ID = "/{userId}";
    public static final String LIST = "/list";
    public static final String INFO = "/info";
    public static final String QUERY = "/query";
    public static final String REST = "/rest";
    public static final String SYSTEM = "/system";
    public static final String PUBLIC = "/public";
    public static final String EXTERNAL = "/external";
    public static final String INTERNAL = "/internal";

    public static String query(String path, Map<String, String> queryParams) {
        if (BaseServicePath.isBlank(path)) {
            return path;
        }
        if (queryParams == null || queryParams.isEmpty()) {
            log.debug("No query parameter arrived to add to path [{0}] ", new Object[]{path});
            return path;
        }
        List<String> queryParts = queryParams.entrySet().stream().map(e -> BaseServicePath.encodeValue((String)e.getKey()) + SIGN_EQUALS + BaseServicePath.encodeValue((String)e.getValue())).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder(path);
        sb.append(SIGN_QUESTION);
        sb.append(BaseServicePath.join(queryParts, SIGN_AND));
        return sb.toString();
    }

    public static String fillParam(String urlPath, String paramKey, String value) {
        String encodedParamKey = BaseServicePath.encodeValue(paramKey);
        String encodedValue = BaseServicePath.encodeValue(value);
        return BaseServicePath.replace(urlPath, "{" + encodedParamKey + "}", encodedValue);
    }

    public static String encodeValue(String value) {
        if (BaseServicePath.isBlank(value)) {
            return value;
        }
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return value;
        }
    }

    public static String path(String ... strings) {
        if (strings == null) {
            return null;
        }
        return BaseServicePath.join(Arrays.asList(strings), EMPTY);
    }

    public static String join(List<String> strings, String delimiter) {
        if (strings == null) {
            return null;
        }
        return strings.stream().collect(Collectors.joining(delimiter));
    }

    public static boolean isBlank(String string) {
        return string == null || string.isBlank();
    }

    public static String replace(String text, String searchString, String replacement) {
        if (BaseServicePath.isBlank(text) || BaseServicePath.isBlank(searchString) || BaseServicePath.isBlank(replacement)) {
            return text;
        }
        String searchText = text;
        int INDEX_NOT_FOUND = -1;
        int max = -1;
        int start = 0;
        int end = searchText.indexOf(searchString, start);
        if (end == INDEX_NOT_FOUND) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != INDEX_NOT_FOUND) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = searchText.indexOf(searchString, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }
}

