/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.model.base;

import hu.icellmobilsoft.coffee.model.base.IVersionable;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import jakarta.validation.constraints.NotNull;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

@MappedSuperclass
public abstract class AbstractEntity
implements IVersionable,
Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="X__VERSION", precision=20, scale=0)
    @NotNull
    @Version
    private long version;
    @Transient
    private Long internalVersion;

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        if (this.internalVersion == null || this.version != version) {
            this.internalVersion = this.version;
        }
        this.version = version;
    }

    public void rollbackVersion() {
        if (this.internalVersion != null) {
            this.version = this.internalVersion;
            this.internalVersion = null;
        }
    }

    public void updateVersion() {
        this.internalVersion = this.version;
    }

    public String toString() {
        ToStringBuilder s = new ToStringBuilder((Object)this);
        for (PropertyDescriptor property : PropertyUtils.getPropertyDescriptors((Object)this)) {
            String name = property.getName();
            Class<?> propertyType = property.getPropertyType();
            if (ClassUtils.isAssignable(propertyType, AbstractEntity.class)) {
                s.append(name, (Object)propertyType.getSimpleName());
                continue;
            }
            if (propertyType == byte[].class || propertyType == Blob.class || propertyType == Clob.class || propertyType == InputStream.class || propertyType == OutputStream.class || propertyType == Reader.class || propertyType == Writer.class) {
                s.append(name, (Object)propertyType.getSimpleName());
                continue;
            }
            try {
                s.append(name, property.getReadMethod().invoke((Object)this, new Object[0]));
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).warn("Error in toString for property [{0}]: [{1}]", new Object[]{name, e.getLocalizedMessage()});
            }
        }
        return s.toString();
    }
}

