/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.model.base;

import hu.icellmobilsoft.coffee.model.base.ClassFieldsAndMethodsCache;
import hu.icellmobilsoft.coffee.model.base.exception.ProviderException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractProvider {
    private static ClassFieldsAndMethodsCache classFieldsAndMethodsCache = new ClassFieldsAndMethodsCache();

    protected Field getFieldByMethod(Method method, List<Field> allFields) {
        for (Field field : allFields) {
            String fieldName = field.getName();
            String suffixMethodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            List<CallSite> possibleMethodNames = List.of("get" + suffixMethodName, "is" + suffixMethodName);
            if (!possibleMethodNames.contains(method.getName()) || !field.getDeclaringClass().equals(method.getDeclaringClass())) continue;
            return field;
        }
        throw new ProviderException("Field is not found based on the name of the annotated method: " + method.getDeclaringClass() + "." + method.getName());
    }

    protected Pair<List<Field>, List<Method>> getAllFieldsAndMethods(Class<?> clazz) {
        return classFieldsAndMethodsCache.getFieldsAndMethods(clazz);
    }
}

