/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.model.base;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ClassFieldsAndMethodsCache<K extends Class, V extends Pair<List<Field>, List<Method>>>
extends LinkedHashMap<K, V> {
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private final int cacheSize;

    public ClassFieldsAndMethodsCache() {
        this(10000);
    }

    public ClassFieldsAndMethodsCache(int cacheSize) {
        super(cacheSize);
        this.cacheSize = cacheSize;
    }

    private List<Field> getAllFields(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>(this.getAllFields(clazz.getSuperclass()));
        result.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return Collections.unmodifiableList(result);
    }

    private List<Method> getAllMethods(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Method> result = new ArrayList<Method>(this.getAllMethods(clazz.getSuperclass()));
        result.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        return Collections.unmodifiableList(result);
    }

    public Pair<List<Field>, List<Method>> getFieldsAndMethods(Class<?> clazz) {
        if (this.containsKey(clazz)) {
            return (Pair)this.get(clazz);
        }
        Pair fieldMethodPair = Pair.of(this.getAllFields(clazz), this.getAllMethods(clazz));
        this.put(clazz, fieldMethodPair);
        return fieldMethodPair;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.cacheSize;
    }
}

