/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.model.base.audit;

import hu.icellmobilsoft.coffee.model.base.AbstractProvider;
import hu.icellmobilsoft.coffee.model.base.annotation.CreatedBy;
import hu.icellmobilsoft.coffee.model.base.annotation.CurrentUser;
import hu.icellmobilsoft.coffee.model.base.annotation.ModifiedBy;
import hu.icellmobilsoft.coffee.model.base.exception.ProviderException;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

@Dependent
public class AuditProvider
extends AbstractProvider {
    @Inject
    private BeanManager manager;

    @PrePersist
    public void prePersist(Object entity) {
        Object value;
        Pair<List<Field>, List<Method>> pair = this.getAllFieldsAndMethods(entity.getClass());
        List allFields = (List)pair.getLeft();
        for (Field field : allFields) {
            this.setPropertyIfAnnotated(entity, field, CreatedBy.class);
            if (!field.isAnnotationPresent(ModifiedBy.class) || !field.getAnnotation(ModifiedBy.class).onCreate()) continue;
            value = this.resolvePrincipal(field.getType());
            this.setProperty(entity, field, value);
        }
        for (Method method : (List)pair.getRight()) {
            this.setPropertyIfGetterAnnotated(entity, allFields, method, CreatedBy.class);
            if (!method.isAnnotationPresent(ModifiedBy.class) || !method.getAnnotation(ModifiedBy.class).onCreate()) continue;
            value = this.resolvePrincipal(method.getReturnType());
            Field field = this.getFieldByMethod(method, allFields);
            this.setProperty(entity, field, value);
        }
    }

    private void setPropertyIfGetterAnnotated(Object entity, List<Field> allFields, Method method, Class<? extends Annotation> annotationClass) {
        if (method.isAnnotationPresent(annotationClass)) {
            Object value = this.resolvePrincipal(method.getReturnType());
            Field field = this.getFieldByMethod(method, allFields);
            this.setProperty(entity, field, value);
        }
    }

    private void setPropertyIfAnnotated(Object entity, Field field, Class<? extends Annotation> annotationClass) {
        if (field.isAnnotationPresent(annotationClass)) {
            Object value = this.resolvePrincipal(field.getType());
            this.setProperty(entity, field, value);
        }
    }

    @PreUpdate
    public void preUpdate(Object entity) {
        Pair<List<Field>, List<Method>> pair = this.getAllFieldsAndMethods(entity.getClass());
        List allFields = (List)pair.getLeft();
        for (Field field : allFields) {
            this.setPropertyIfAnnotated(entity, field, ModifiedBy.class);
        }
        List allMethods = (List)pair.getRight();
        for (Method method : allMethods) {
            this.setPropertyIfGetterAnnotated(entity, allFields, method, ModifiedBy.class);
        }
    }

    private void setProperty(Object entity, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(entity, value);
        }
        catch (Exception e) {
            throw new ProviderException("Failed to write value [" + value + "] to field[" + field + "], entity [" + entity.getClass() + "]: " + e.getLocalizedMessage(), e);
        }
    }

    private Object resolvePrincipal(Class<?> propertyClass) {
        Set beans = this.manager.getBeans(propertyClass, new Annotation[]{() -> CurrentUser.class});
        if (!beans.isEmpty() && beans.size() == 1) {
            Bean bean = (Bean)beans.iterator().next();
            return this.manager.getReference(bean, propertyClass, this.manager.createCreationalContext((Contextual)bean));
        }
        throw new IllegalArgumentException("Principal " + (beans.isEmpty() ? "not found" : "not unique"));
    }
}

