/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.model.base.generator;

import hu.icellmobilsoft.coffee.model.base.IIdentifiedEntity;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;

public class EntityIdGenerator
implements IdentifierGenerator {
    private static final long DATE_2013_01_01 = 1356998400000L;
    private static final int RADIX = 36;
    private static final int MAX_NUM_SYS = 62;
    private static final char[] LOWERCASE;
    private static final char[] UPPERCASE;
    private static final char[] ALL_LETTER;
    private static final String ALL_LETTER_STRING;
    private static int generatedIndex;
    private static final int PID;
    private static final String PID62;
    private static final String PID36;
    private static final Random RANDOM;

    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        if (object instanceof IIdentifiedEntity) {
            IIdentifiedEntity entity = (IIdentifiedEntity)object;
            if (entity.getId() == null) {
                return EntityIdGenerator.generateId();
            }
            return entity.getId();
        }
        return EntityIdGenerator.generateId();
    }

    public static String generateId() {
        int xInd = EntityIdGenerator.getNextIndex();
        Date xDate = new Date();
        xDate.setTime(xDate.getTime() - 1356998400000L);
        String xRes = EntityIdGenerator.convertToRadix(xDate.getTime(), 36L);
        xRes = EntityIdGenerator.paddL(xRes, 8, '0');
        StringBuilder builder = new StringBuilder();
        builder.append(xRes);
        long nano = System.nanoTime();
        String xNano = EntityIdGenerator.convertToRadix(nano, 36L);
        builder.append(xNano.substring(xNano.length() - 4, xNano.length()));
        builder.append(EntityIdGenerator.paddL(EntityIdGenerator.convertToRadix(RANDOM.nextInt(1296), 36L), 2, '0'));
        builder.append(EntityIdGenerator.paddL(EntityIdGenerator.convertToRadix(xInd, 36L), 2, '0'));
        return builder.toString();
    }

    private static synchronized int getNextIndex() {
        if (++generatedIndex > 1295) {
            generatedIndex = 0;
        }
        return generatedIndex;
    }

    private static String paddL(String str, int length, char padd) {
        return StringUtils.leftPad((String)str, (int)length, (char)padd);
    }

    private static String convertToRadix(long inNum, long radix) {
        long numDivRadix;
        long num = inNum;
        Object result = "";
        do {
            numDivRadix = num / radix;
            long dig = (num % radix + radix) % radix;
            result = ALL_LETTER[(int)dig] + (String)result;
        } while ((num = numDivRadix) != 0L);
        return result;
    }

    static {
        int i;
        generatedIndex = 0;
        UPPERCASE = new char[26];
        for (i = 65; i < 91; ++i) {
            EntityIdGenerator.UPPERCASE[i - 65] = (char)i;
        }
        LOWERCASE = new char[26];
        for (i = 97; i < 123; ++i) {
            EntityIdGenerator.LOWERCASE[i - 97] = (char)i;
        }
        ALL_LETTER = new char[62];
        for (i = 48; i < 58; ++i) {
            EntityIdGenerator.ALL_LETTER[i - 48] = (char)i;
        }
        for (i = 10; i < 36; ++i) {
            EntityIdGenerator.ALL_LETTER[i] = UPPERCASE[i - 10];
        }
        for (i = 36; i < 62; ++i) {
            EntityIdGenerator.ALL_LETTER[i] = LOWERCASE[i - 10 - 26];
        }
        ALL_LETTER_STRING = new String(ALL_LETTER);
        PID = Integer.valueOf(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        PID62 = EntityIdGenerator.paddL(EntityIdGenerator.convertToRadix(PID, 62L), 3, '0').substring(0, 3);
        PID36 = EntityIdGenerator.paddL(EntityIdGenerator.convertToRadix(PID, 36L), 3, '0').substring(0, 3);
        RANDOM = new Random();
    }
}

