/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.model.base.javatime.listener;

import hu.icellmobilsoft.coffee.model.base.AbstractProvider;
import hu.icellmobilsoft.coffee.model.base.exception.ProviderException;
import hu.icellmobilsoft.coffee.model.base.javatime.annotation.CreatedOn;
import hu.icellmobilsoft.coffee.model.base.javatime.annotation.ModifiedOn;
import jakarta.enterprise.context.Dependent;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

@Dependent
public class TimestampsProvider
extends AbstractProvider {
    @PrePersist
    public void prePersist(Object entity) {
        this.updateTimestamps(entity, CreatedOn.class);
    }

    @PreUpdate
    public void preUpdate(Object entity) {
        this.updateTimestamps(entity, ModifiedOn.class);
    }

    private void updateTimestamps(Object entity, Class<? extends Annotation> annotationClass) {
        long sysTime = System.currentTimeMillis();
        Pair<List<Field>, List<Method>> pair = this.getAllFieldsAndMethods(entity.getClass());
        List allFields = (List)pair.getLeft();
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            this.setValue(entity, field.getType(), sysTime, field);
        }
        for (Method method : (List)pair.getRight()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            Field field = this.getFieldByMethod(method, allFields);
            this.setValue(entity, field.getType(), sysTime, field);
        }
    }

    private void setValue(Object entity, Class<?> fieldClass, long systime, Field field) {
        Comparable<Calendar> object = null;
        try {
            if (this.isCalendarClass(fieldClass)) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(systime);
                object = cal;
            } else if (this.isDateClass(fieldClass)) {
                object = fieldClass.getConstructor(Long.TYPE).newInstance(systime);
            } else if (this.isOffsetDateTimeClass(fieldClass)) {
                object = OffsetDateTime.ofInstant(Instant.ofEpochMilli(systime), ZoneId.systemDefault());
            } else if (this.isOffsetTimeClass(fieldClass)) {
                object = OffsetTime.ofInstant(Instant.ofEpochMilli(systime), ZoneId.systemDefault());
            } else if (this.isLocalDateTimeClass(fieldClass)) {
                object = LocalDateTime.ofInstant(Instant.ofEpochMilli(systime), ZoneId.systemDefault());
            } else if (this.isLocalDateClass(fieldClass)) {
                object = LocalDateTime.ofInstant(Instant.ofEpochMilli(systime), ZoneId.systemDefault()).toLocalDate();
            } else if (this.isInstantClass(fieldClass)) {
                object = Instant.ofEpochMilli(systime);
            } else {
                throw new IllegalArgumentException("Annotated fieldClass is not a date class: " + fieldClass);
            }
            field.setAccessible(true);
            field.set(entity, object);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new ProviderException("Failed to write value [" + object + "] to field [" + field + "], fieldClass [" + fieldClass + "], entity [" + entity.getClass() + "]: " + exception.getLocalizedMessage(), exception);
        }
    }

    private boolean isCalendarClass(Class<?> field) {
        return Calendar.class.isAssignableFrom(field);
    }

    private boolean isDateClass(Class<?> field) {
        return Date.class.isAssignableFrom(field);
    }

    private boolean isOffsetDateTimeClass(Class<?> field) {
        return OffsetDateTime.class.isAssignableFrom(field);
    }

    private boolean isOffsetTimeClass(Class<?> field) {
        return OffsetTime.class.isAssignableFrom(field);
    }

    private boolean isLocalDateTimeClass(Class<?> field) {
        return LocalDateTime.class.isAssignableFrom(field);
    }

    private boolean isLocalDateClass(Class<?> field) {
        return LocalDate.class.isAssignableFrom(field);
    }

    private boolean isInstantClass(Class<?> field) {
        return Instant.class.isAssignableFrom(field);
    }
}

