/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.mp.restclient.exception;

import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.module.mp.restclient.exception.FaultTypeClasses;
import hu.icellmobilsoft.coffee.module.mp.restclient.exception.FaultTypeParserExtension;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;

public class FaultTypeParser {
    private FaultTypeParser() {
    }

    public static Enum parseFaultType(String faultTypeString) {
        for (Class<? extends Enum> faultTypeClass : FaultTypeParser.getFaultTypeClasses()) {
            Enum fault = EnumUtils.getEnum(faultTypeClass, (String)faultTypeString);
            if (fault == null) continue;
            return fault;
        }
        Logger.getLogger(FaultTypeParser.class).warn("FaultType not exists in enum for messages, faultType: [" + faultTypeString + "]");
        return CoffeeFaultType.OPERATION_FAILED;
    }

    private static List<Class<? extends Enum>> getFaultTypeClasses() {
        ArrayList<Class<? extends Enum>> faultTypeClassesList = new ArrayList<Class<? extends Enum>>(FaultTypeParserExtension.getFaultTypeClasses());
        Instance instance = CDI.current().select(FaultTypeClasses.class, new Annotation[0]);
        FaultTypeClasses faultTypeClassesElement = null;
        try {
            faultTypeClassesElement = (FaultTypeClasses)instance.get();
            faultTypeClassesList.addAll(faultTypeClassesElement.getFaultTypeClasses());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return faultTypeClassesList;
    }
}

