/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.mp.restclient.exception;

import hu.icellmobilsoft.coffee.cdi.annotation.FaultTypeCode;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import jakarta.annotation.Priority;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FaultTypeParserExtension
implements Extension {
    private static final int DEFAULT_FAULT_TYPE_PRIORITY = 500;
    private static List<Class<? extends Enum>> faultTypeClasses = new ArrayList<Class<? extends Enum>>();
    private static volatile Map<Class<? extends Enum>, Integer> faultTypePriorityMap = new HashMap<Class<? extends Enum>, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        if (!annotatedType.isAnnotationPresent(FaultTypeCode.class) && !javaClass.isAnnotationPresent(FaultTypeCode.class) || InvocationHandler.class.isAssignableFrom(javaClass) || !javaClass.isEnum()) return;
        Logger.getLogger(FaultTypeParserExtension.class).debug("IFaultType implementation found:[{0}], registering as fault type enum", new Object[]{javaClass});
        Class<FaultTypeParserExtension> clazz = FaultTypeParserExtension.class;
        synchronized (FaultTypeParserExtension.class) {
            faultTypePriorityMap.put(javaClass, FaultTypeParserExtension.getPriority(annotatedType));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterTypeDiscovery(@Observes AfterTypeDiscovery afterTypeDiscovery) {
        Class<FaultTypeParserExtension> clazz = FaultTypeParserExtension.class;
        synchronized (FaultTypeParserExtension.class) {
            List sortedFaultTypes = faultTypePriorityMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
            faultTypeClasses.addAll(sortedFaultTypes);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static <T> int getPriority(AnnotatedType<T> annotatedType) {
        int priority = 0;
        if (annotatedType.isAnnotationPresent(Priority.class)) {
            Priority priorityAnnotation = (Priority)annotatedType.getAnnotation(Priority.class);
            priority = priorityAnnotation.value();
        }
        return priority > 0 ? priority : 500;
    }

    public static Collection<Class<? extends Enum>> getFaultTypeClasses() {
        return List.copyOf(faultTypeClasses);
    }
}

