/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.mp.restclient.provider;

import hu.icellmobilsoft.coffee.dto.common.commonservice.BaseExceptionResultType;
import hu.icellmobilsoft.coffee.dto.exception.AccessDeniedException;
import hu.icellmobilsoft.coffee.dto.exception.BONotFoundException;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.RestClientResponseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.module.mp.restclient.exception.FaultTypeParser;
import hu.icellmobilsoft.coffee.tool.gson.JsonUtil;
import hu.icellmobilsoft.coffee.tool.utils.marshalling.MarshallingUtil;
import jakarta.enterprise.context.Dependent;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

@Dependent
public class DefaultBaseExceptionResponseExceptionMapper
implements ResponseExceptionMapper<BaseException> {
    public static final int HTTP_STATUS_I_AM_A_TEAPOT = 418;

    public BaseException toThrowable(Response response) {
        int responseStatus = response.getStatus();
        BaseExceptionResultType dto = this.readEntity(response, BaseExceptionResultType.class);
        if (dto != null) {
            RestClientResponseException restClientResponseException = new RestClientResponseException(MessageFormat.format("REST client exception! ResponseStatus [{0}].", responseStatus), (Throwable)this.fromExceptionResult(dto, responseStatus));
            restClientResponseException.setClassName(dto.getClassName());
            restClientResponseException.setException(dto.getException());
            restClientResponseException.setService(dto.getService());
            restClientResponseException.setStatusCode(responseStatus);
            return restClientResponseException;
        }
        return new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, MessageFormat.format("HTTP error status [{0}], content [{1}]", responseStatus, response.readEntity(String.class)));
    }

    protected <T> T readEntity(Response response, Class<T> dtoClass) {
        String entity = (String)response.readEntity(String.class);
        if (StringUtils.isBlank((CharSequence)entity)) {
            return null;
        }
        MediaType mediaType = response.getMediaType();
        if (mediaType == null) {
            return null;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)mediaType.getSubtype(), (CharSequence[])new CharSequence[]{"json"})) {
            return (T)JsonUtil.toObject((String)entity, dtoClass);
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)mediaType.getSubtype(), (CharSequence[])new CharSequence[]{"xml"})) {
            return (T)MarshallingUtil.unmarshallUncheckedXml((String)entity, dtoClass);
        }
        if (mediaType.equals((Object)MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
            if (StringUtils.startsWith((CharSequence)entity, (CharSequence)"{")) {
                return (T)JsonUtil.toObject((String)entity, dtoClass);
            }
            if (StringUtils.startsWith((CharSequence)entity, (CharSequence)"<")) {
                return (T)MarshallingUtil.unmarshallUncheckedXml((String)entity, dtoClass);
            }
            return null;
        }
        return null;
    }

    private BaseException fromExceptionResult(BaseExceptionResultType baseExceptionResultType, int responseStatus) {
        if (baseExceptionResultType == null) {
            return null;
        }
        if (responseStatus == 418) {
            return new BONotFoundException(FaultTypeParser.parseFaultType(baseExceptionResultType.getFaultType()), this.concatExceptionMessage(baseExceptionResultType), (Throwable)this.fromExceptionResultCausedBy(baseExceptionResultType.getCausedBy()));
        }
        if (responseStatus == Response.Status.UNAUTHORIZED.getStatusCode()) {
            return new AccessDeniedException(FaultTypeParser.parseFaultType(baseExceptionResultType.getFaultType()), this.concatExceptionMessage(baseExceptionResultType), (Throwable)this.fromExceptionResultCausedBy(baseExceptionResultType.getCausedBy()));
        }
        return new BaseException(FaultTypeParser.parseFaultType(baseExceptionResultType.getFaultType()), this.concatExceptionMessage(baseExceptionResultType), (Throwable)this.fromExceptionResultCausedBy(baseExceptionResultType.getCausedBy()));
    }

    private BaseException fromExceptionResultCausedBy(BaseExceptionResultType baseExceptionResultType) {
        if (baseExceptionResultType == null) {
            return null;
        }
        return new BaseException(FaultTypeParser.parseFaultType(baseExceptionResultType.getFaultType()), this.concatExceptionMessage(baseExceptionResultType), (Throwable)this.fromExceptionResultCausedBy(baseExceptionResultType.getCausedBy()));
    }

    private String concatExceptionMessage(BaseExceptionResultType baseExceptionResultType) {
        return String.join((CharSequence)" : ", baseExceptionResultType.getClassName(), baseExceptionResultType.getException());
    }
}

