/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.mp.restclient.provider;

import hu.icellmobilsoft.coffee.cdi.logger.LogProducer;
import hu.icellmobilsoft.coffee.rest.log.RequestResponseLogger;
import hu.icellmobilsoft.coffee.rest.log.annotation.enumeration.LogSpecifierTarget;
import hu.icellmobilsoft.coffee.rest.utils.RestLoggerUtil;
import hu.icellmobilsoft.coffee.tool.utils.stream.OutputStreamCopier;
import hu.icellmobilsoft.coffee.tool.utils.string.StringHelper;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@Priority(value=3100)
@Dependent
public class DefaultLoggerClientRequestFilter
implements ClientRequestFilter {
    @Inject
    private RequestResponseLogger requestResponseLogger;

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (RestLoggerUtil.logDisabled((ClientRequestContext)requestContext, (LogSpecifierTarget)LogSpecifierTarget.CLIENT_REQUEST)) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append(">> ").append(this.getClass().getName()).append(" request ->\n");
        msg.append(this.logUrl(requestContext));
        msg.append(this.logHeader(requestContext));
        msg.append(this.logEntity(requestContext));
        LogProducer.logToAppLogger(appLogger -> appLogger.info(msg.toString()), DefaultLoggerClientRequestFilter.class);
    }

    protected String logUrl(ClientRequestContext requestContext) throws IOException {
        StringBuilder msg = new StringBuilder();
        msg.append("> url: [").append(requestContext.getMethod()).append(" ").append(requestContext.getUri()).append("]\n");
        return msg.toString();
    }

    protected String logHeader(ClientRequestContext requestContext) throws IOException {
        StringBuilder msg = new StringBuilder();
        msg.append("> headers: [");
        for (Map.Entry entry : requestContext.getHeaders().entrySet()) {
            msg.append("\n>    ").append((String)entry.getKey()).append(":").append(StringHelper.maskPropertyValue((String)((String)entry.getKey()), entry.getValue()));
        }
        msg.append("]\n");
        msg.append("> cookies: [");
        for (Map.Entry entry : requestContext.getCookies().entrySet()) {
            msg.append("\n>    ").append((String)entry.getKey()).append(":").append(StringHelper.maskPropertyValue((String)((String)entry.getKey()), entry.getValue()));
        }
        msg.append("]\n");
        return msg.toString();
    }

    protected String logEntity(ClientRequestContext requestContext) throws IOException {
        StringBuilder msg = new StringBuilder();
        Object entity = requestContext.getEntity();
        MediaType mediaType = requestContext.getMediaType();
        if (entity != null) {
            msg.append(this.requestResponseLogger.printEntity(entity, Integer.valueOf(RestLoggerUtil.getMaxEntityLogSize((ClientRequestContext)requestContext, (LogSpecifierTarget)LogSpecifierTarget.CLIENT_REQUEST)), "> ", true, mediaType));
        } else {
            OutputStreamCopier osc = new OutputStreamCopier(requestContext.getEntityStream());
            requestContext.setEntityStream((OutputStream)osc);
            String requestText = new String(osc.getCopy(), StandardCharsets.UTF_8);
            msg.append(this.requestResponseLogger.printEntity((Object)requestText, Integer.valueOf(RestLoggerUtil.getMaxEntityLogSize((ClientRequestContext)requestContext, (LogSpecifierTarget)LogSpecifierTarget.CLIENT_REQUEST)), "> ", true, mediaType));
        }
        return msg.toString();
    }
}

