/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.mp.restclient.provider;

import hu.icellmobilsoft.coffee.cdi.logger.AppLogger;
import hu.icellmobilsoft.coffee.cdi.logger.LogProducer;
import hu.icellmobilsoft.coffee.cdi.logger.ThisLogger;
import hu.icellmobilsoft.coffee.rest.log.RequestResponseLogger;
import hu.icellmobilsoft.coffee.rest.log.annotation.enumeration.LogSpecifierTarget;
import hu.icellmobilsoft.coffee.rest.utils.RestLoggerUtil;
import hu.icellmobilsoft.coffee.tool.utils.string.StringHelper;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

@Priority(value=1000)
@Dependent
public class DefaultLoggerClientResponseFilter
implements ClientResponseFilter {
    @Inject
    @ThisLogger
    private AppLogger log;
    @Inject
    private RequestResponseLogger requestResponseLogger;

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (RestLoggerUtil.logDisabled((ClientRequestContext)requestContext, (LogSpecifierTarget)LogSpecifierTarget.CLIENT_RESPONSE)) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("<< ").append(this.getClass().getName()).append(" response from [").append(requestContext.getUri()).append("] ->\n");
        msg.append(this.logStatus(requestContext, responseContext));
        msg.append(this.logHeader(requestContext, responseContext));
        msg.append(this.logEntity(requestContext, responseContext));
        LogProducer.logToAppLogger(appLogger -> appLogger.info(msg.toString()), DefaultLoggerClientResponseFilter.class);
    }

    protected String logStatus(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        StringBuilder msg = new StringBuilder();
        msg.append("< status: [");
        if (responseContext.getStatusInfo() != null) {
            msg.append(responseContext.getStatusInfo().getStatusCode());
            msg.append("]; family: [").append(responseContext.getStatusInfo().getFamily());
            msg.append("]; reasonPhrase: [").append(responseContext.getStatusInfo().getReasonPhrase()).append("]");
        }
        msg.append("]\n");
        return msg.toString();
    }

    protected String logHeader(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        StringBuilder msg = new StringBuilder();
        msg.append("< headers: [");
        for (Map.Entry entry : responseContext.getHeaders().entrySet()) {
            msg.append("\n<    ").append((String)entry.getKey()).append(":").append(StringHelper.maskPropertyValue((String)((String)entry.getKey()), entry.getValue()));
        }
        msg.append("]\n");
        msg.append("< cookies: [");
        for (Map.Entry entry : responseContext.getCookies().entrySet()) {
            msg.append("\n<    ").append((String)entry.getKey()).append(":").append(StringHelper.maskPropertyValue((String)((String)entry.getKey()), entry.getValue()));
        }
        msg.append("]\n");
        msg.append("< locale: [").append(responseContext.getLanguage()).append("]\n");
        msg.append("< location: [").append(responseContext.getLocation()).append("]\n");
        return msg.toString();
    }

    protected String logEntity(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (requestContext == null || responseContext == null) {
            return null;
        }
        InputStream in = responseContext.getEntityStream();
        try {
            int maxResponseEntityLogSize = this.getMaxResponseEntityLogSize(requestContext, responseContext);
            if (in == null) {
                return this.requestResponseLogger.printEntity(null, Integer.valueOf(maxResponseEntityLogSize), "< ");
            }
            byte[] responseEntity = IOUtils.toByteArray((InputStream)in);
            responseContext.setEntityStream((InputStream)new ByteArrayInputStream(responseEntity));
            return this.requestResponseLogger.printEntity(responseEntity, Integer.valueOf(maxResponseEntityLogSize), "< ");
        }
        catch (IOException e) {
            this.log.error("Error in logging response entity: " + e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private int getMaxResponseEntityLogSize(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        int maxResponseEntityLogSize = RestLoggerUtil.getMaxEntityLogSize((ClientRequestContext)requestContext, (LogSpecifierTarget)LogSpecifierTarget.CLIENT_RESPONSE);
        if (maxResponseEntityLogSize != 0 && Objects.equals(responseContext.getMediaType(), MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
            maxResponseEntityLogSize = 5000;
        }
        return maxResponseEntityLogSize;
    }
}

