/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.mp.restclient.util;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;

public class MPRestClientUtil {
    public static BaseException toBaseException(Exception e) {
        if (e instanceof WebApplicationException) {
            return MPRestClientUtil.toBaseException((WebApplicationException)e);
        }
        if (e instanceof ProcessingException) {
            return MPRestClientUtil.toBaseException((ProcessingException)e);
        }
        return new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, "REST client unhandled exception: " + e.getLocalizedMessage(), (Throwable)e);
    }

    public static BaseException toBaseException(WebApplicationException e) {
        if (e.getCause() instanceof BaseException) {
            return (BaseException)e.getCause();
        }
        return new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, "REST client handled exception: " + e.getLocalizedMessage(), (Throwable)e);
    }

    public static TechnicalException toBaseException(ProcessingException e) {
        return new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, e.getLocalizedMessage(), (Throwable)e);
    }
}

