/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redis.annotation;

import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.enterprise.util.Nonbinding;
import jakarta.inject.Qualifier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Qualifier
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
public @interface RedisConnection {
    @Nonbinding
    public String configKey();

    @Nonbinding
    public String poolConfigKey() default "default";

    public static final class Literal
    extends AnnotationLiteral<RedisConnection>
    implements RedisConnection {
        private static final long serialVersionUID = 1L;
        private final String configKey;
        private final String poolConfigKey;

        public Literal(String configKey, String poolConfigKey) {
            this.configKey = configKey;
            this.poolConfigKey = poolConfigKey;
        }

        public Literal(String configKey) {
            this.configKey = configKey;
            this.poolConfigKey = "default";
        }

        @Override
        @Nonbinding
        public String configKey() {
            return this.configKey;
        }

        @Override
        @Nonbinding
        public String poolConfigKey() {
            return this.poolConfigKey;
        }
    }
}

