/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redis.config;

import hu.icellmobilsoft.coffee.module.redis.config.RedisConfig;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import org.eclipse.microprofile.config.Config;

@Dependent
public class ManagedRedisConfig
implements RedisConfig {
    public static final String REDIS_PREFIX = "coffee.redis";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String PASSWORD = "password";
    public static final String DATABASE = "database";
    public static final String POOL_MAXTOTAL = "maxtotal";
    public static final String POOL_MAXIDLE = "maxidle";
    public static final String TIMEOUT = "timeout";
    public static final String KEY_DELIMITER = ".";
    private static final String POOL = "pool";
    @Inject
    private Config config;
    private String configKey;
    private String poolConfigKey;

    @Override
    public String getHost() {
        return this.config.getOptionalValue(this.joinKey(HOST), String.class).orElse("localhost");
    }

    @Override
    public Integer getPort() {
        return this.config.getOptionalValue(this.joinKey(PORT), Integer.class).orElse(6380);
    }

    @Override
    public String getPassword() {
        return this.config.getOptionalValue(this.joinKey(PASSWORD), String.class).orElse(null);
    }

    @Override
    public Integer getDatabase() {
        return this.config.getOptionalValue(this.joinKey(DATABASE), Integer.class).orElse(0);
    }

    @Override
    public Integer getPoolMaxTotal() {
        return this.config.getOptionalValue(this.joinKey("pool." + this.getPoolConfigKey() + ".maxtotal"), Integer.class).orElse(64);
    }

    @Override
    public Integer getPoolMaxIdle() {
        return this.config.getOptionalValue(this.joinKey("pool." + this.getPoolConfigKey() + ".maxidle"), Integer.class).orElse(16);
    }

    @Override
    public Integer getTimeout() {
        return this.config.getOptionalValue(this.joinKey(TIMEOUT), Integer.class).orElse(5000);
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public String getPoolConfigKey() {
        return this.poolConfigKey;
    }

    public void setPoolConfigKey(String poolConfigKey) {
        this.poolConfigKey = poolConfigKey;
    }

    private String joinKey(String key) {
        return String.join((CharSequence)KEY_DELIMITER, REDIS_PREFIX, this.configKey, key);
    }
}

