/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redis.health;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.InvalidParameterException;
import hu.icellmobilsoft.coffee.module.redis.config.ManagedRedisConfig;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.health.HealthUtil;
import jakarta.enterprise.context.ApplicationScoped;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@ApplicationScoped
public class RedisHealth {
    public HealthCheckResponse checkConnection(ManagedRedisConfig managedRedisConfig, String builderName) throws BaseException {
        return this.checkConnection(managedRedisConfig, builderName, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public HealthCheckResponse checkConnection(ManagedRedisConfig managedRedisConfig, String builderName, String nodeId) throws BaseException {
        if (managedRedisConfig == null) {
            throw new InvalidParameterException("ManagedRedisConfig is null!");
        }
        if (StringUtils.isBlank((CharSequence)builderName)) {
            throw new InvalidParameterException("builderName is mandatory!");
        }
        HealthCheckResponseBuilder builder = HealthCheckResponse.builder().name(builderName);
        builder.withData("nodeName", HealthUtil.getNodeId((String)nodeId));
        builder.withData("URL", this.createUrl(managedRedisConfig));
        String host = managedRedisConfig.getHost();
        int port = managedRedisConfig.getPort();
        int database = managedRedisConfig.getDatabase();
        int timeout = (int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        try (JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, managedRedisConfig.getPassword(), database);){
            HealthCheckResponse healthCheckResponse;
            block15: {
                Jedis jedis = jedisPool.getResource();
                try {
                    jedis.ping();
                    builder.up();
                    healthCheckResponse = builder.build();
                    if (jedis == null) break block15;
                }
                catch (Throwable throwable) {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jedis.close();
            }
            return healthCheckResponse;
        }
        catch (Exception e) {
            Logger.getLogger(RedisHealth.class).error(MessageFormat.format("Error occurred while establishing connection! configKey [{0}], message: [{1}]", managedRedisConfig.getConfigKey(), e.getLocalizedMessage()), (Throwable)e);
            builder.down();
            return builder.build();
        }
    }

    public String createUrl(ManagedRedisConfig managedRedisConfig) {
        if (managedRedisConfig == null) {
            throw new IllegalArgumentException("ManagedRedisConfig is null!");
        }
        return managedRedisConfig.getHost() + ":" + managedRedisConfig.getPort() + "/" + managedRedisConfig.getDatabase();
    }
}

